/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.minemaarten.signals.capabilities.CapabilityDestinationProvider;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketSpawnParticle;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.NetworkStation;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.Train;
import com.minemaarten.signals.rail.network.mc.ISerializableNetworkObject;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.NetworkSerializer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MCNetworkStation
extends NetworkStation<MCPos>
implements ISerializableNetworkObject {
    private final List<MCPos> potentialNeighbors = new ArrayList<MCPos>();

    public MCNetworkStation(MCPos pos, String stationName) {
        super(pos, stationName);
        for (EnumHeading heading : EnumHeading.VALUES) {
            this.potentialNeighbors.add(pos.offset(heading));
        }
    }

    public static MCNetworkStation fromTag(NBTTagCompound tag) {
        return new MCNetworkStation(new MCPos(tag), tag.func_74779_i("station"));
    }

    public static MCNetworkStation fromByteBuf(ByteBuf buf) {
        return new MCNetworkStation(new MCPos(buf), ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        ((MCPos)this.getPos()).writeToNBT(tag);
        tag.func_74778_a("station", this.stationName);
    }

    @Override
    public void writeToBuf(ByteBuf b) {
        ((MCPos)this.getPos()).writeToBuf(b);
        ByteBufUtils.writeUTF8String((ByteBuf)b, (String)this.stationName);
    }

    @Override
    public List<MCPos> getNetworkNeighbors() {
        return this.potentialNeighbors;
    }

    @Override
    public List<MCPos> getConnectedRailPositions(RailNetwork<MCPos> network) {
        ArrayList<MCPos> rails = new ArrayList<MCPos>(1);
        for (MCPos neighbor : this.potentialNeighbors) {
            if (network.railObjects.getRail(neighbor) == null) continue;
            rails.add(neighbor);
        }
        return rails;
    }

    @Override
    public boolean isTrainApplicable(Train<MCPos> train, Pattern destinationRegex) {
        if (super.isTrainApplicable(train, destinationRegex)) {
            return true;
        }
        World world = ((MCPos)this.getPos()).getWorld();
        if (world != null) {
            MCTrain mcTrain = (MCTrain)train;
            for (EntityMinecart cart : mcTrain.getCarts()) {
                if (!this.isCartApplicable(world, cart, destinationRegex)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCartApplicable(World world, EntityMinecart cart, Pattern destinationRegex) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            CapabilityDestinationProvider cap;
            TileEntity te;
            BlockPos neighborPos = ((MCPos)this.getPos()).getPos().func_177972_a(dir);
            if (!world.func_175667_e(neighborPos) || (te = world.func_175625_s(neighborPos)) == null || (cap = (CapabilityDestinationProvider)te.getCapability(CapabilityDestinationProvider.INSTANCE, null)) == null || !cap.isCartApplicable(te, cart, destinationRegex)) continue;
            for (int i = 0; i < 10; ++i) {
                double x = (double)((MCPos)this.getPos()).getPos().func_177958_n() + world.field_73012_v.nextDouble();
                double z = (double)((MCPos)this.getPos()).getPos().func_177952_p() + world.field_73012_v.nextDouble();
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.ENCHANTMENT_TABLE, x, ((MCPos)this.getPos()).getPos().func_177956_o() + 1, z, dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()), world);
            }
            return true;
        }
        return false;
    }

    @Override
    public NetworkSerializer.EnumNetworkObject getType() {
        return NetworkSerializer.EnumNetworkObject.STATION;
    }
}

