/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.NetworkState;
import com.minemaarten.signals.rail.network.RailEdge;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.Train;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RailPathfinder<TPos extends IPosition<TPos>> {
    private final RailNetwork<TPos> network;
    private final NetworkState<TPos> state;

    public RailPathfinder(RailNetwork<TPos> network, NetworkState<TPos> state) {
        this.network = network;
        this.state = state;
    }

    public RailRoute.RailRouteResult<TPos> pathfindToDestination(TPos start, Train<TPos> train, Pattern destinationRegex, EnumHeading direction) {
        Set<TPos> stations = this.network.getStationRails(train, destinationRegex);
        if (stations.isEmpty()) {
            return RailRoute.RailRouteResult.noStations();
        }
        RailRoute<TPos> route = this.pathfindToDestination(start, direction, stations);
        return route != null ? RailRoute.RailRouteResult.success(route) : RailRoute.RailRouteResult.noPath();
    }

    public RailRoute<TPos> pathfindToDestination(TPos start, EnumHeading direction, Set<TPos> goals) {
        Map<Object, Object> startToFirstIntersections;
        List<RailEdge<TPos>> startToFirstIntersectionList;
        if (goals.isEmpty()) {
            return null;
        }
        RailEdge<TPos> startPosEdge = this.network.findEdge(start);
        List<RailEdge<TPos>> list = startToFirstIntersectionList = startPosEdge != null && !startPosEdge.isAtStartOrEnd(start) ? startPosEdge.createExitPoints(start, direction) : null;
        if (startToFirstIntersectionList == null) {
            startToFirstIntersections = Collections.emptyMap();
        } else {
            if (startToFirstIntersectionList.isEmpty()) {
                return null;
            }
            startToFirstIntersections = startToFirstIntersectionList.stream().collect(Collectors.toMap(e -> e.other(start), e -> e));
        }
        PriorityQueue<AStarRailNode> queue = new PriorityQueue<AStarRailNode>();
        HashSet<IPosition> traversedRails = new HashSet<IPosition>();
        HashMap<IPosition, AStarRailNode> nodeMap = new HashMap<IPosition, AStarRailNode>();
        AStarRailNode bestRoute = null;
        for (IPosition goal : goals) {
            RailEdge<TPos> railEdge;
            int endIndex;
            AStarRailNode goalNode = new AStarRailNode(this, goal, null, start);
            goalNode.distanceFromGoal = 0;
            queue.add(goalNode);
            nodeMap.put(goal, goalNode);
            if (start.equals(goal)) {
                bestRoute = goalNode;
                continue;
            }
            if (startPosEdge == null || !startPosEdge.contains(goal)) continue;
            int startIndex = startPosEdge.getIndex(start);
            if (startIndex > (endIndex = startPosEdge.getIndex(goal))) {
                int n = startIndex;
                startIndex = endIndex;
                endIndex = n;
            }
            if (!(railEdge = startPosEdge.subEdge(startIndex, endIndex)).canTravelFrom(start) || direction != null && direction != EnumHeading.getOpposite(railEdge.headingForEndpoint(start))) continue;
            bestRoute = new AStarRailNode(this, goal, railEdge, goal);
            bestRoute.distanceFromGoal = endIndex - startIndex;
        }
        while (!queue.isEmpty()) {
            RailEdge startToIntersection;
            RailEdge<IPosition> destEdge;
            AStarRailNode node = (AStarRailNode)queue.remove();
            traversedRails.add(node.pos);
            if (bestRoute != null && node.distanceFromGoal >= bestRoute.distanceFromGoal) break;
            Collection<RailEdge<IPosition>> networkEntryEdges = this.network.findConnectedEdgesBackwards(node.pos);
            if (networkEntryEdges.isEmpty() && goals.contains(node.pos) && (destEdge = this.network.findEdge(node.pos)) != null && !destEdge.isAtStartOrEnd(node.pos)) {
                networkEntryEdges = destEdge.createEntryPoints(node.pos);
            }
            Iterable<RailEdge<IPosition<Object>>> entryEdges = (startToIntersection = (RailEdge)startToFirstIntersections.get(node.pos)) != null ? Iterables.concat(networkEntryEdges, Collections.singleton(startToIntersection)) : networkEntryEdges;
            for (RailEdge railEdge : entryEdges) {
                if (node.edge != null && node.edge.headingForEndpoint(node.pos) == railEdge.headingForEndpoint(node.pos)) continue;
                IPosition nextPos = railEdge.other(node.pos);
                AStarRailNode neighborNode = (AStarRailNode)nodeMap.get(nextPos);
                if (neighborNode == null) {
                    neighborNode = new AStarRailNode(this, nextPos, railEdge, start);
                    nodeMap.put(nextPos, neighborNode);
                }
                if (!neighborNode.checkImprovementAndUpdate(node, railEdge, railEdge.getPathLength(this.state))) continue;
                queue.add(neighborNode);
                if (!neighborNode.pos.equals(start) || bestRoute != null && neighborNode.distanceFromGoal >= bestRoute.distanceFromGoal) continue;
                bestRoute = neighborNode;
            }
        }
        return bestRoute != null ? this.toRailRoute(bestRoute) : null;
    }

    private RailRoute<TPos> toRailRoute(AStarRailNode node) {
        ArrayList<RailRoute.RailRouteNode<IPosition>> routeNodes = new ArrayList<RailRoute.RailRouteNode<IPosition>>();
        ArrayList routeEdges = new ArrayList();
        LinkedHashSet routeRails = new LinkedHashSet();
        ArrayList<NetworkSignal<IPosition>> routeSignals = new ArrayList<NetworkSignal<IPosition>>();
        if (node.edge != null) {
            routeRails.addAll(node.edge.traverseWithFirst(node.pos).stream().map(NetworkObject::getPos).collect(Collectors.toList()));
            routeEdges.add(node.edge);
            routeNodes.addAll(node.edge.getIntersectionsWithFirst(node.pos));
            routeSignals.addAll((Collection<NetworkSignal<IPosition>>)node.edge.traverseSignalsWithFirst(node.pos));
        }
        AStarRailNode prevNode = node;
        for (node = node.getNextNode(); node != null && node.edge != null; node = node.getNextNode()) {
            routeRails.addAll(node.edge.traverseWithFirst(node.pos).stream().map(NetworkObject::getPos).collect(Collectors.toList()));
            routeEdges.add(node.edge);
            EnumHeading dirIn = EnumHeading.getOpposite(prevNode.edge.headingForEndpoint(node.pos));
            EnumHeading dirOut = EnumHeading.getOpposite(node.edge.headingForEndpoint(node.pos));
            routeNodes.add(new RailRoute.RailRouteNode<IPosition>(node.pos, dirIn, dirOut));
            routeNodes.addAll(node.edge.getIntersectionsWithFirst(node.pos));
            routeSignals.addAll((Collection<NetworkSignal<IPosition>>)node.edge.traverseSignalsWithFirst(node.pos));
            prevNode = node;
        }
        return new RailRoute(ImmutableList.copyOf(routeNodes), ImmutableList.copyOf(routeRails), ImmutableList.copyOf(routeEdges), ImmutableList.copyOf(routeSignals));
    }

    public static class AStarRailNode
    implements Comparable<AStarRailNode> {
        private int distanceFromGoal = Integer.MAX_VALUE;
        private AStarRailNode prevNode;
        private final TPos goal;
        private final TPos pos;
        public RailEdge<TPos> edge;
        final /* synthetic */ RailPathfinder this$0;

        public AStarRailNode(TPos pos, RailEdge<TPos> edge, TPos goal) {
            this.this$0 = this$0;
            this.pos = pos;
            this.edge = edge;
            this.goal = goal;
        }

        public boolean checkImprovementAndUpdate(AStarRailNode node, RailEdge<TPos> edge, int edgeLength) {
            int nodeDist = node.distanceFromGoal + edgeLength;
            if (nodeDist < this.distanceFromGoal) {
                this.prevNode = node;
                this.edge = edge;
                this.distanceFromGoal = nodeDist;
                return true;
            }
            return false;
        }

        public AStarRailNode getNextNode() {
            return this.prevNode;
        }

        public TPos getRail() {
            return this.pos;
        }

        private double getCost() {
            return (double)this.distanceFromGoal + (this.goal != null ? this.getDistance(this.goal) : 0.0);
        }

        @Override
        public int compareTo(AStarRailNode node) {
            return Double.compare(this.getCost(), node.getCost());
        }

        private double getDistance(TPos rail) {
            return Math.sqrt(this.pos.distanceSq(rail));
        }
    }
}

