/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.base.Functions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IAdjacentCheckable;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.NetworkState;
import com.minemaarten.signals.rail.network.PosAABB;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import com.minemaarten.signals.rail.network.RailRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RailEdge<TPos extends IPosition<TPos>>
implements Iterable<NetworkRail<TPos>>,
IAdjacentCheckable<RailEdge<TPos>> {
    private static final double RED_SIGNAL_PENALTY = 10000.0;
    public final RailObjectHolder<TPos> railObjects;
    public final ImmutableList<NetworkRail<TPos>> edge;
    private final Map<Pair<Integer, Integer>, RailEdge<TPos>> subEdgeCache = new HashMap<Pair<Integer, Integer>, RailEdge<TPos>>();
    private final ImmutableList<NetworkSignal<TPos>> signals;
    private final List<RailRoute.RailRouteNode<TPos>> intersections;
    private final List<RailRoute.RailRouteNode<TPos>> intersectionsReversed;
    public final TPos startPos;
    public final TPos endPos;
    public final EnumHeading startHeading;
    public final EnumHeading endHeading;
    public final int length;
    public final EnumDirectionalityResult directionality;
    private final PosAABB<TPos> aabb;

    public RailEdge(RailObjectHolder<TPos> allRailObjects, ImmutableList<NetworkRail<TPos>> edge) {
        this(allRailObjects, edge, null);
    }

    public RailEdge(RailObjectHolder<TPos> allRailObjects, ImmutableList<NetworkRail<TPos>> edge, List<RailRoute.RailRouteNode<TPos>> intersections) {
        EnumDirectionalityResult rawDirectionality;
        this.railObjects = allRailObjects.subSelection((Collection<NetworkRail<TPos>>)edge);
        if (intersections != null) {
            intersections = intersections.stream().filter(i -> this.railObjects.get((IPosition)i.pos) != null).collect(Collectors.toList());
        }
        if ((rawDirectionality = this.determineDirectionality(allRailObjects, edge)) == EnumDirectionalityResult.UNIDIRECTIONAL_REVERSE) {
            edge = edge.reverse();
            this.directionality = EnumDirectionalityResult.UNIDIRECTIONAL_NO_CHANGE;
        } else {
            this.directionality = rawDirectionality;
        }
        IPosition firstPos = (IPosition)((NetworkRail)edge.get(0)).getPos();
        IPosition lastPos = (IPosition)((NetworkRail)edge.get(edge.size() - 1)).getPos();
        if (this.directionality == EnumDirectionalityResult.BIDIRECTIONAL) {
            int compareResult = firstPos.compareTo(lastPos);
            if (compareResult == 0 && (compareResult = ((IPosition)((NetworkRail)edge.get(1)).getPos()).compareTo(((NetworkRail)edge.get(edge.size() - 2)).getPos())) == 0) {
                throw new IllegalStateException("");
            }
            if (compareResult > 0) {
                edge = edge.reverse();
                if (intersections != null) {
                    intersections = this.reverseIntersections(intersections);
                }
                firstPos = (IPosition)((NetworkRail)edge.get(0)).getPos();
                lastPos = (IPosition)((NetworkRail)edge.get(edge.size() - 1)).getPos();
            }
        }
        this.edge = edge;
        this.startPos = firstPos;
        this.endPos = lastPos;
        this.aabb = new PosAABB(edge.stream().map(x -> (IPosition)x.getPos()).collect(Collectors.toSet()));
        this.startHeading = this.startPos.getRelativeHeading(((NetworkRail)edge.get(1)).getPos());
        this.endHeading = this.endPos.getRelativeHeading(((NetworkRail)edge.get(edge.size() - 2)).getPos());
        this.length = edge.size();
        this.intersections = intersections == null ? this.computeIntersections(allRailObjects) : intersections;
        this.intersectionsReversed = this.reverseIntersections(this.intersections);
        this.signals = this.computeSignals();
    }

    private ImmutableList<NetworkSignal<TPos>> computeSignals() {
        Multimap posToSignals = (Multimap)this.railObjects.getSignals().stream().collect(Multimaps.toMultimap(NetworkSignal::getRailPos, (Function)Functions.identity(), ArrayListMultimap::create));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (NetworkRail rail : this.edge) {
            builder.addAll((Iterable)posToSignals.get(rail.getPos()));
        }
        return builder.build();
    }

    public ImmutableList<NetworkSignal<TPos>> traverseSignalsWithFirst(TPos pos) {
        if (pos.equals(this.startPos)) {
            return this.signals;
        }
        if (pos.equals(this.endPos)) {
            return this.signals.reverse();
        }
        throw new IllegalArgumentException("Pos " + pos + "not a start or end pos of edge " + this);
    }

    private List<RailRoute.RailRouteNode<TPos>> reverseIntersections(List<RailRoute.RailRouteNode<TPos>> intersections) {
        ArrayList<RailRoute.RailRouteNode<TPos>> intersectionsReversed = new ArrayList<RailRoute.RailRouteNode<TPos>>(intersections.size());
        for (int i = intersections.size() - 1; i >= 0; --i) {
            intersectionsReversed.add(intersections.get(i).reverse());
        }
        return intersectionsReversed;
    }

    private List<RailRoute.RailRouteNode<TPos>> computeIntersections(RailObjectHolder<TPos> allRailObjects) {
        ArrayList<RailRoute.RailRouteNode<TPos>> inter = new ArrayList<RailRoute.RailRouteNode<TPos>>();
        for (int i = 1; i < this.edge.size() - 1; ++i) {
            NetworkRail rail = (NetworkRail)this.edge.get(i);
            if (allRailObjects.getNeighborRailCount(rail.getPotentialNeighborRailLocations()) <= 2) continue;
            NetworkRail prev = (NetworkRail)this.edge.get(i - 1);
            NetworkRail next = (NetworkRail)this.edge.get(i + 1);
            EnumHeading dirIn = ((IPosition)rail.getPos()).getRelativeHeading(prev.getPos());
            EnumHeading dirOut = ((IPosition)rail.getPos()).getRelativeHeading(next.getPos());
            inter.add(new RailRoute.RailRouteNode(rail.getPos(), dirIn, dirOut));
        }
        return inter;
    }

    private EnumDirectionalityResult determineDirectionality(RailObjectHolder<TPos> allRailObjects, ImmutableList<NetworkRail<TPos>> edge) {
        NetworkRail cur;
        NetworkRail prev;
        int i;
        boolean forwardsOk = true;
        boolean backwardsOk = true;
        for (i = 1; i < edge.size() - 1; ++i) {
            EnumHeading nextDir;
            prev = (NetworkRail)edge.get(i - 1);
            cur = (NetworkRail)edge.get(i);
            NetworkRail next = (NetworkRail)edge.get(i + 1);
            EnumHeading prevDir = ((IPosition)cur.getPos()).getRelativeHeading(prev.getPos());
            if (prevDir != (nextDir = ((IPosition)next.getPos()).getRelativeHeading(cur.getPos())) || prevDir == null) continue;
            List signals = this.railObjects.getNeighborSignals(cur.getPotentialNeighborObjectLocations()).filter(s -> s.getRailPos().equals(cur.getPos())).collect(Collectors.toList());
            for (NetworkSignal signal : signals) {
                if (signal.heading == nextDir) {
                    backwardsOk = false;
                    continue;
                }
                if (signal.heading != nextDir.getOpposite()) continue;
                forwardsOk = false;
            }
        }
        for (i = 1; i < edge.size(); ++i) {
            prev = (NetworkRail)edge.get(i - 1);
            cur = (NetworkRail)edge.get(i);
            EnumHeading dir = ((IPosition)cur.getPos()).getRelativeHeading(prev.getPos());
            if (dir != null) continue;
            if (allRailObjects.findRailsLinkingTo((IPosition)cur.getPos()).anyMatch(r -> ((IPosition)r.getPos()).equals(prev.getPos()))) {
                backwardsOk = false;
                continue;
            }
            forwardsOk = false;
        }
        if (backwardsOk && forwardsOk) {
            return EnumDirectionalityResult.BIDIRECTIONAL;
        }
        if (backwardsOk) {
            return EnumDirectionalityResult.UNIDIRECTIONAL_REVERSE;
        }
        if (forwardsOk) {
            return EnumDirectionalityResult.UNIDIRECTIONAL_NO_CHANGE;
        }
        return EnumDirectionalityResult.ZERODIRECTIONAL;
    }

    public NetworkRail<TPos> get(int index) {
        return (NetworkRail)this.edge.get(index);
    }

    public boolean contains(TPos pos) {
        return this.aabb.isInAABB(pos);
    }

    public boolean isAtStartOrEnd(TPos pos) {
        return pos.equals(this.startPos) || pos.equals(this.endPos);
    }

    public TPos other(TPos pos) {
        if (pos.equals(this.startPos)) {
            return this.endPos;
        }
        if (pos.equals(this.endPos)) {
            return this.startPos;
        }
        throw new IllegalArgumentException("Pos " + pos + "not a start or end pos of edge " + this);
    }

    public EnumHeading headingForEndpoint(TPos pos) {
        if (pos.equals(this.startPos)) {
            return this.startHeading;
        }
        if (pos.equals(this.endPos)) {
            return this.endHeading;
        }
        throw new IllegalArgumentException("Pos " + pos + "not a start or end pos of edge " + this);
    }

    public Collection<RailEdge<TPos>> createEntryPoints(TPos destination) {
        if (this.isAtStartOrEnd(destination)) {
            throw new IllegalArgumentException("Cannot create an entry point from start/end pos!");
        }
        int destinationIndex = this.getIndex(destination);
        ArrayList<RailEdge<TPos>> entryPoints = new ArrayList<RailEdge<TPos>>(2);
        RailEdge<TPos> subEdge = this.subEdge(0, destinationIndex);
        if (subEdge.directionality.canTravelForwards) {
            entryPoints.add(subEdge);
        }
        subEdge = this.subEdge(destinationIndex, this.edge.size() - 1);
        if (subEdge.directionality.canTravelBackwards) {
            entryPoints.add(subEdge);
        }
        return entryPoints;
    }

    public List<RailEdge<TPos>> createExitPoints(TPos from, EnumHeading direction) {
        ArrayList<RailEdge<TPos>> exitEdges = new ArrayList<RailEdge<TPos>>(2);
        int destinationIndex = this.getIndex(from);
        IPosition nextNeighbor = (IPosition)((NetworkRail)this.edge.get(destinationIndex + 1)).getPos();
        EnumHeading nextNeighborHeading = nextNeighbor.getRelativeHeading(from);
        if (direction == null || nextNeighborHeading == null || nextNeighborHeading == direction) {
            RailEdge<TPos> subEdge = this.subEdge(destinationIndex, this.edge.size() - 1);
            if (subEdge.directionality.canTravelForwards) {
                exitEdges.add(subEdge);
            }
        }
        IPosition prevNeighbor = (IPosition)((NetworkRail)this.edge.get(destinationIndex - 1)).getPos();
        EnumHeading prevNeighborHeading = prevNeighbor.getRelativeHeading(from);
        if (direction == null || prevNeighborHeading == null || prevNeighborHeading == direction) {
            RailEdge<TPos> subEdge = this.subEdge(0, destinationIndex);
            if (subEdge.directionality.canTravelBackwards) {
                exitEdges.add(subEdge);
            }
        }
        return exitEdges;
    }

    public int getPathLength(NetworkState<TPos> state) {
        int curLength = this.length;
        for (NetworkSignal signal : this.signals) {
            if (state.getLampStatus((IPosition)signal.getPos()) != ISignal.EnumLampStatus.RED) continue;
            curLength = (int)((double)curLength + 10000.0);
        }
        return curLength;
    }

    public int getIndex(TPos pos) {
        INetworkObject<TPos> destObj = this.railObjects.get(pos);
        Validate.notNull(destObj);
        int destinationIndex = this.edge.indexOf(destObj);
        if (destinationIndex < 0) {
            throw new IllegalStateException("Edge " + this + " does not contain " + pos);
        }
        return destinationIndex;
    }

    @Override
    public Iterator<NetworkRail<TPos>> iterator() {
        return this.edge.iterator();
    }

    public ImmutableList<NetworkRail<TPos>> traverseWithFirst(TPos firstPos) {
        if (this.startPos.equals(firstPos)) {
            return this.edge;
        }
        if (this.endPos.equals(firstPos)) {
            return this.edge.reverse();
        }
        throw new IllegalStateException("Pos " + firstPos + " not start/end of edge " + this);
    }

    public List<RailRoute.RailRouteNode<TPos>> getIntersectionsWithFirst(TPos firstPos) {
        if (this.startPos.equals(firstPos)) {
            return this.intersections;
        }
        if (this.endPos.equals(firstPos)) {
            return this.intersectionsReversed;
        }
        throw new IllegalStateException("Pos " + firstPos + " not start/end of edge " + this);
    }

    public RailEdge<TPos> subEdge(int startIndex, int endIndexInclusive) {
        ImmutablePair key = new ImmutablePair((Object)startIndex, (Object)endIndexInclusive);
        RailEdge<TPos> e = this.subEdgeCache.get(key);
        if (e == null) {
            ImmutableList subEdge = this.edge.subList(startIndex, endIndexInclusive + 1);
            e = new RailEdge<TPos>(this.railObjects, subEdge, this.intersections);
            this.subEdgeCache.put((Pair<Integer, Integer>)key, e);
        }
        return e;
    }

    public RailEdge<TPos> combine(RailEdge<TPos> other, TPos commonPos) {
        ImmutableList.Builder rails = new ImmutableList.Builder();
        ImmutableList.Builder intersections = new ImmutableList.Builder();
        TPos startPos = this.other(commonPos);
        ImmutableList<NetworkRail<TPos>> firstList = this.traverseWithFirst(startPos);
        for (int i = 0; i < firstList.size() - 1; ++i) {
            rails.add(firstList.get(i));
        }
        rails.addAll(other.traverseWithFirst(commonPos));
        intersections.addAll(this.getIntersectionsWithFirst(startPos));
        intersections.add(new RailRoute.RailRouteNode<TPos>(commonPos, EnumHeading.getOpposite(this.headingForEndpoint(commonPos)), EnumHeading.getOpposite(other.headingForEndpoint(commonPos))));
        intersections.addAll(other.getIntersectionsWithFirst(commonPos));
        return new RailEdge<TPos>(this.railObjects.combine(other.railObjects), rails.build(), intersections.build());
    }

    public boolean canTravelFrom(TPos pos) {
        if (pos.equals(this.startPos)) {
            return this.directionality.canTravelForwards;
        }
        return this.directionality.canTravelBackwards;
    }

    public String toString() {
        return this.startPos + " -> " + this.endPos;
    }

    public boolean equals(Object other) {
        if (other instanceof RailEdge) {
            RailEdge edge = (RailEdge)other;
            return this.startPos.equals(edge.startPos) && this.endPos.equals(edge.endPos) && Objects.equals((Object)this.startHeading, (Object)edge.startHeading) && Objects.equals((Object)this.endHeading, (Object)edge.endHeading) && this.directionality == edge.directionality;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.startPos.hashCode() * 13;
        hash = hash * 13 + this.endPos.hashCode();
        hash = hash * 13 + (this.startHeading == null ? 5 : this.startHeading.hashCode());
        hash = hash * 13 + (this.endHeading == null ? 5 : this.endHeading.hashCode());
        return hash;
    }

    @Override
    public boolean isAdjacent(RailEdge<TPos> other) {
        return this.contains(other.startPos) || this.contains(other.endPos);
    }

    public static enum EnumDirectionalityResult {
        BIDIRECTIONAL(true, true),
        UNIDIRECTIONAL_NO_CHANGE(true, false),
        UNIDIRECTIONAL_REVERSE(false, true),
        ZERODIRECTIONAL(false, false);

        public boolean canTravelForwards;
        public boolean canTravelBackwards;

        private EnumDirectionalityResult(boolean canTravelForwards, boolean canTravelBackwards) {
            this.canTravelForwards = canTravelForwards;
            this.canTravelBackwards = canTravelBackwards;
        }
    }
}

