/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.block;

import com.google.common.base.Predicate;
import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.block.BlockBase;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockSignalBase
extends BlockBase {
    public static PropertyEnum<ISignal.EnumLampStatus> LAMP_STATUS = PropertyEnum.func_177709_a((String)"lamp_status", ISignal.EnumLampStatus.class);
    public static PropertyEnum<EnumFacing> FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockSignalBase(Class<? extends TileEntitySignalBase> tileClass, String name) {
        super(tileClass, name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LAMP_STATUS});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176736_b() * 4 + ((ISignal.EnumLampStatus)((Object)state.func_177229_b(LAMP_STATUS))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = super.func_176203_a(meta);
        return state.func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)(meta / 4))).func_177226_a(LAMP_STATUS, (Comparable)((Object)ISignal.EnumLampStatus.values()[meta % 4]));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        ArrayList<EnumFacing> railFacings = new ArrayList<EnumFacing>(4);
        for (EnumFacing horFacing : EnumFacing.field_176754_o) {
            BlockPos railPos = pos.func_177972_a(horFacing);
            if (RailManager.getInstance().getRail(worldIn, railPos, worldIn.func_180495_p(railPos)) == null) continue;
            railFacings.add(horFacing);
        }
        EnumFacing orientation = railFacings.size() == 1 ? ((EnumFacing)railFacings.get(0)).func_176746_e() : placer.func_174811_aO();
        return this.func_176223_P().func_177226_a(FACING, (Comparable)orientation);
    }

    public int func_180656_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        ISignal.EnumLampStatus lampStatus = (ISignal.EnumLampStatus)((Object)state.func_177229_b(LAMP_STATUS));
        if (!(worldIn instanceof WorldServer) || state.func_177230_c() != this || lampStatus != ISignal.EnumLampStatus.GREEN || ((EnumFacing)state.func_177229_b(FACING)).func_176746_e() != side) {
            return 0;
        }
        TileEntitySignalBase signal = (TileEntitySignalBase)worldIn.func_175625_s(pos);
        signal.func_145834_a((World)((WorldServer)worldIn));
        return 15;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

