/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.util;

import com.feed_the_beast.ftblib.lib.item.ItemEntry;
import com.feed_the_beast.ftblib.lib.item.ItemEntryWithCount;
import com.feed_the_beast.ftblib.lib.tile.IChangeCallback;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.latmod.yabba.YabbaConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AntibarrelData
implements ICapabilitySerializable<NBTTagCompound>,
IItemHandler {
    @CapabilityInject(value=AntibarrelData.class)
    public static Capability<AntibarrelData> CAP;
    private IChangeCallback callback;
    public final Map<ItemEntry, ItemEntryWithCount> items;
    private ItemEntryWithCount[] itemsArray;
    private int totalItemCount;
    private NBTTagCompound cachedNetData;

    public static AntibarrelData get(ItemStack stack) {
        AntibarrelData data = (AntibarrelData)stack.getCapability(CAP, null);
        if (BlockUtils.hasData((ItemStack)stack)) {
            data.deserializeNBT(BlockUtils.getData((ItemStack)stack));
            BlockUtils.removeData((ItemStack)stack);
        }
        return data;
    }

    public AntibarrelData(@Nullable IChangeCallback c) {
        this.callback = c;
        this.items = new LinkedHashMap<ItemEntry, ItemEntryWithCount>();
    }

    public void clear() {
        this.items.clear();
        this.itemsArray = null;
        this.totalItemCount = -1;
        this.cachedNetData = null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CAP || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CAP || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ItemEntryWithCount entry : this.items.values()) {
            if (entry.isEmpty()) continue;
            list.func_74742_a((NBTBase)entry.serializeNBT());
        }
        if (!list.func_82582_d()) {
            nbt.func_74782_a("Inv", (NBTBase)list);
        }
        return nbt;
    }

    public NBTTagCompound serializeNBTForNet() {
        if (this.cachedNetData != null) {
            return this.cachedNetData;
        }
        this.cachedNetData = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ItemEntryWithCount entry : this.items.values()) {
            if (entry.isEmpty()) continue;
            list.func_74742_a((NBTBase)entry.serializeNBT());
        }
        if (!list.func_82582_d()) {
            this.cachedNetData.func_74782_a("Inv", (NBTBase)list);
        }
        return this.cachedNetData;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.clear();
        NBTTagList list = nbt.func_150295_c("Inv", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            ItemEntryWithCount entryc = new ItemEntryWithCount(nbt1);
            if (entryc.isEmpty()) continue;
            this.items.put(entryc.entry, entryc);
        }
    }

    public void copyFrom(AntibarrelData data) {
        this.clear();
        this.totalItemCount = data.totalItemCount;
        for (ItemEntryWithCount entry : data.items.values()) {
            this.items.put(entry.entry, new ItemEntryWithCount(entry.entry, entry.count));
        }
    }

    public int getSlots() {
        return this.items.size() + 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot <= 0 || slot > this.items.size() ? ItemStack.field_190927_a : this.getItemArray()[slot - 1].getStack(false);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemEntryWithCount entryc;
        if (slot < 0 || slot > this.items.size() || stack.func_190926_b() || stack.func_77985_e()) {
            return stack;
        }
        ItemEntry entry = ItemEntry.get((ItemStack)stack);
        int added = 0;
        if (slot == 0) {
            entryc = this.items.get(entry);
            if (entryc != null) {
                added = Math.min(YabbaConfig.general.antibarrel_items_per_type - entryc.count, stack.func_190916_E());
            } else if (this.items.size() < YabbaConfig.general.antibarrel_capacity) {
                entryc = new ItemEntryWithCount(entry, 0);
                this.items.put(entry, entryc);
                this.itemsArray = null;
                this.totalItemCount = -1;
                this.cachedNetData = null;
                added = Math.min(YabbaConfig.general.antibarrel_items_per_type, stack.func_190916_E());
            }
        } else {
            entryc = this.getItemArray()[slot - 1];
            if (entryc.entry.equalsEntry(entry)) {
                added = Math.min(YabbaConfig.general.antibarrel_items_per_type - entryc.count, stack.func_190916_E());
            }
        }
        if (entryc != null && added > 0) {
            if (!simulate) {
                entryc.count += added;
                this.totalItemCount = -1;
                this.cachedNetData = null;
                if (this.callback != null) {
                    this.callback.onContentsChanged(false);
                }
            }
            return added == stack.func_190916_E() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - added));
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot <= 0 || slot > this.items.size() || amount < 1) {
            return ItemStack.field_190927_a;
        }
        ItemEntryWithCount entryc = this.getItemArray()[slot - 1];
        if (entryc.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        int extracted = Math.min(amount, entryc.count);
        ItemStack is = entryc.entry.getStack(extracted, true);
        if (!simulate) {
            entryc.count -= extracted;
            this.totalItemCount = -1;
            this.cachedNetData = null;
            if (this.callback != null) {
                this.callback.onContentsChanged(false);
            }
        }
        return is;
    }

    private ItemEntryWithCount[] getItemArray() {
        if (this.itemsArray == null) {
            this.itemsArray = this.items.values().toArray(new ItemEntryWithCount[0]);
        }
        return this.itemsArray;
    }

    public int getSlotLimit(int slot) {
        return YabbaConfig.general.antibarrel_items_per_type;
    }

    public int getTotalItemCount() {
        if (this.totalItemCount >= 0) {
            return this.totalItemCount;
        }
        this.totalItemCount = 0;
        for (ItemEntryWithCount entry : this.items.values()) {
            this.totalItemCount += entry.count;
        }
        return this.totalItemCount;
    }
}

