/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.BarrelType;
import com.latmod.yabba.tile.IBarrelBase;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IItemBarrel
extends IBarrelBase,
IItemHandler {
    public static boolean canInsertItem(ItemStack stored, ItemStack stack) {
        if (stored.func_77973_b() != stack.func_77973_b() || stored.func_77960_j() != stack.func_77960_j() || stored.func_77952_i() != stack.func_77952_i()) {
            return false;
        }
        return Objects.equals(InvUtils.nullIfEmpty((NBTTagCompound)stored.func_77978_p()), InvUtils.nullIfEmpty((NBTTagCompound)stack.func_77978_p())) && stored.areCapsCompatible(stack);
    }

    @Override
    default public BarrelType getType() {
        return BarrelType.ITEM;
    }

    public int getItemCount();

    public void setRawItemCount(int var1);

    public ItemStack getStoredItemType();

    public void setRawItemType(ItemStack var1);

    default public ItemStack getStackInSlot(int slot) {
        if (this.getItemCount() <= 0) {
            return ItemStack.field_190927_a;
        }
        this.getStoredItemType().func_190920_e(this.getTier().creative() ? 1000000000 : this.getItemCount());
        return this.getStoredItemType();
    }

    default public int getSlots() {
        return 1;
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int capacity;
        boolean canInsert;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean storedIsEmpty = this.getStoredItemType().func_190926_b();
        boolean bl = canInsert = storedIsEmpty || IItemBarrel.canInsertItem(this.getStoredItemType(), stack);
        if (!storedIsEmpty && this.getTier().creative()) {
            return canInsert ? ItemStack.field_190927_a : stack;
        }
        if (this.getItemCount() > 0) {
            capacity = this.getMaxItems(this.getStoredItemType());
            if (this.getItemCount() >= capacity) {
                return canInsert && this.hasUpgrade(YabbaItems.UPGRADE_VOID) ? ItemStack.field_190927_a : stack;
            }
        } else {
            capacity = this.getMaxItems(stack);
        }
        if (canInsert) {
            int size = Math.min(stack.func_190916_E(), capacity - this.getItemCount());
            if (size > 0 && !simulate) {
                if (this.getStoredItemType().func_190926_b()) {
                    this.setStoredItemType(stack, size);
                } else {
                    this.setItemCount(this.getItemCount() + size);
                }
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - size));
        }
        return stack;
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        if (this.getItemCount() <= 0 || this.getStoredItemType().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.getTier().creative()) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStoredItemType(), (int)Math.min(amount, this.getStoredItemType().func_77976_d()));
        }
        ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStoredItemType(), (int)Math.min(Math.min(amount, this.getItemCount()), this.getStoredItemType().func_77976_d()));
        if (!simulate) {
            this.setItemCount(this.getItemCount() - stack.func_190916_E());
        }
        return stack;
    }

    default public int getSlotLimit(int slot) {
        return this.getMaxItems(this.getStoredItemType());
    }

    default public int getFreeSpace() {
        return this.getMaxItems(this.getStoredItemType()) - this.getItemCount();
    }

    default public void setStoredItemType(ItemStack type, int amount) {
        boolean prevEmpty = this.getStoredItemType().func_190926_b();
        if (type.func_190926_b()) {
            type = ItemStack.field_190927_a;
        }
        if (amount <= 0) {
            amount = 0;
            if (!this.isLocked()) {
                type = ItemStack.field_190927_a;
            }
        }
        if (!type.func_190926_b()) {
            type = ItemHandlerHelper.copyStackWithSize((ItemStack)type, (int)1);
            if (this.getTier().creative()) {
                amount = 1000000000;
            }
        }
        this.setRawItemType(type);
        this.setRawItemCount(Math.min(amount, this.getMaxItems(this.getStoredItemType())));
        this.markBarrelDirty(prevEmpty != this.getStoredItemType().func_190926_b());
    }

    default public boolean setItemCount(int v) {
        if (this.getItemCount() != v) {
            boolean isEmpty = this.getItemCount() <= 0;
            this.setRawItemCount(v);
            if (this.getItemCount() <= 0 && !this.isLocked() && !this.getStoredItemType().func_190926_b()) {
                this.setStoredItemType(ItemStack.field_190927_a, 0);
            }
            this.markBarrelDirty(isEmpty != this.getItemCount() <= 0);
            return true;
        }
        return false;
    }

    default public int getMaxItems(ItemStack stack) {
        if (this.getTier().infiniteCapacity()) {
            return 2000000000;
        }
        return this.getTier().maxItemStacks * (stack.func_190926_b() ? 64 : stack.func_77976_d());
    }
}

