/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.util.FluidModifier;

public class FluidUtil {
    public static final String BREW_MODIFIERS_TAG = "brew_modifiers";
    public static final HashMap<String, FluidModifier> MODIFIERS = new HashMap();
    public static final TreeSet<String> SORTED_MODIFIER_KEYS = new TreeSet();

    public static void registerModifier(FluidModifier fluidModifier) {
        MODIFIERS.put(fluidModifier.name, fluidModifier);
        SORTED_MODIFIER_KEYS.add(fluidModifier.name);
    }

    public static void setDefaultValue(Fluid fluid, String name, float value) {
        FluidModifier modifier = MODIFIERS.get(name);
        if (modifier != null) {
            modifier.setDefault(fluid, value);
        }
    }

    public static void setDefaultValues(Fluid fluid, Map<String, Float> valuemap) {
        for (Map.Entry<String, Float> entry : valuemap.entrySet()) {
            FluidUtil.setDefaultValue(fluid, entry.getKey(), entry.getValue().floatValue());
        }
    }

    public static NBTTagCompound createModifiers(FluidStack stack) {
        if (stack.tag == null) {
            stack.tag = new NBTTagCompound();
        }
        NBTTagCompound brew_modifiers = stack.tag.func_74775_l(BREW_MODIFIERS_TAG);
        stack.tag.func_74782_a(BREW_MODIFIERS_TAG, (NBTBase)brew_modifiers);
        return brew_modifiers;
    }

    public static NBTTagCompound getModifiers(FluidStack stack) {
        return stack == null || stack.tag == null ? new NBTTagCompound() : stack.tag.func_74775_l(BREW_MODIFIERS_TAG);
    }

    public static void garbageCollect(FluidStack stack) {
        if (stack.tag == null) {
            return;
        }
        NBTTagCompound brew_modifiers = stack.tag.func_74775_l(BREW_MODIFIERS_TAG);
        if (!brew_modifiers.func_150296_c().stream().anyMatch(key -> brew_modifiers.func_74760_g(key) != 0.0f)) {
            stack.tag.func_82580_o(BREW_MODIFIERS_TAG);
        }
        if (stack.tag.func_186856_d() == 0) {
            stack.tag = null;
        }
    }

    public static Random getRandom(World world, FluidStack stack, int seedoffset) {
        NBTTagCompound brew_modifiers = stack.tag != null ? stack.tag.func_74775_l(BREW_MODIFIERS_TAG) : new NBTTagCompound();
        long seed = world.func_72905_C() ^ (long)(brew_modifiers.hashCode() + seedoffset);
        return new Random(seed);
    }

    public static float getModifier(FluidStack stack, String name) {
        return FluidUtil.getModifier(FluidUtil.getModifiers(stack), stack != null ? stack.getFluid() : null, name);
    }

    public static float getModifier(NBTTagCompound compound, Fluid fluid, String name) {
        FluidModifier modifier = MODIFIERS.get(name);
        return modifier != null ? modifier.getOrDefault(compound, fluid) : 0.0f;
    }
}

