/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.HashMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;

public class FluidModifier {
    public String name;
    public float defaultValue;
    public boolean showAlways;
    public HashMap<Fluid, Float> defaultValues = new HashMap();
    public FormatType formatType = FormatType.LINEAR;

    public FluidModifier(String name, float defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public FluidModifier setShowAlways() {
        this.showAlways = true;
        return this;
    }

    public FluidModifier setFormatType(FormatType type) {
        this.formatType = type;
        return this;
    }

    public void applyEffect(EntityLivingBase target, NBTTagCompound compound, Fluid fluid) {
    }

    public boolean isDefault(NBTTagCompound compound, Fluid fluid) {
        return this.getOrDefault(compound, fluid) == this.defaultValue;
    }

    public float getOrDefault(NBTTagCompound compound, Fluid fluid) {
        if (compound.func_150297_b(this.name, 99)) {
            return compound.func_74760_g(this.name);
        }
        return this.defaultValues.containsKey(fluid) ? this.defaultValues.get(fluid).floatValue() : this.defaultValue;
    }

    public void set(NBTTagCompound compound, float value) {
        compound.func_74776_a(this.name, value);
    }

    public void setDefault(Fluid fluid, float value) {
        this.defaultValues.put(fluid, Float.valueOf(value));
    }

    public String getFormattedText(NBTTagCompound compound, Fluid fluid) {
        float value = this.getOrDefault(compound, fluid);
        switch (this.formatType) {
            case LINEAR: {
                return I18n.func_135052_a((String)"distilling.modifier.dial.linear", (Object[])new Object[]{this.getLocalizedName(), (int)value});
            }
            case PERCENTAGE: {
                return I18n.func_135052_a((String)"distilling.modifier.dial.percent", (Object[])new Object[]{this.getLocalizedName(), (int)value});
            }
            case MULTIPLIER: {
                return I18n.func_135052_a((String)"distilling.modifier.dial.percent", (Object[])new Object[]{this.getLocalizedName(), (int)(value * 100.0f)});
            }
            case NAME_ONLY: {
                return I18n.func_135052_a((String)"distilling.modifier.dial.name", (Object[])new Object[]{this.getLocalizedName()});
            }
        }
        return "";
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)("distilling.modifier." + this.name + ".name"), (Object[])new Object[0]);
    }

    public static enum FormatType {
        LINEAR,
        MULTIPLIER,
        PERCENTAGE,
        NAME_ONLY,
        NONE;

    }
}

