/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import java.util.Collection;
import java.util.List;
import mezz.jei.util.Translator;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.RecipeStillModifier;
import soot.tile.TileEntityStillBase;
import soot.util.FluidUtil;

public class RecipeStillModifierFood
extends RecipeStillModifier {
    private int hungerAdded;
    private float saturationModifier;

    public RecipeStillModifierFood(Collection<Fluid> validFluids, Ingredient catalystInput, int catalystConsumed, int hunger, float saturation) {
        super(validFluids, catalystInput, catalystConsumed);
        this.hungerAdded = hunger;
        this.saturationModifier = saturation;
    }

    @Override
    public void modifyOutput(TileEntityStillBase tile, FluidStack output) {
        NBTTagCompound compound = FluidUtil.createModifiers(output);
        float hunger = this.getModifierOrDefault("hunger", compound, output);
        float saturation = this.getModifierOrDefault("saturation", compound, output);
        compound.func_74776_a("hunger", hunger + (float)this.hungerAdded);
        compound.func_74776_a("saturation", Math.max(saturation, this.saturationModifier));
    }

    @Override
    public void modifyTooltip(List<String> tooltip) {
        super.modifyTooltip(tooltip);
        tooltip.add(tooltip.size() - 1, TextFormatting.BLUE + Translator.translateToLocalFormatted((String)"distilling.effect.add", (Object[])new Object[]{Translator.translateToLocal((String)"distilling.modifier.hunger.name"), this.hungerAdded}));
    }
}

