/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.util.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.RecipeStill;
import soot.tile.TileEntityStillBase;
import soot.util.FluidUtil;

public abstract class RecipeStillModifier
extends RecipeStill {
    public HashSet<Fluid> validFluids = new HashSet();

    public RecipeStillModifier(Collection<Fluid> validFluids, Ingredient catalystInput, int catalystConsumed) {
        super(null, catalystInput, catalystConsumed, null);
        this.validFluids = new HashSet<Fluid>(validFluids);
    }

    @Override
    public boolean matches(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        return stack != null && this.catalystInput.apply(catalyst) && this.validFluids.contains(stack.getFluid()) && stack.amount >= this.getInputConsumed();
    }

    @Override
    public int getInputConsumed() {
        return 1;
    }

    @Override
    public List<FluidStack> getInputs() {
        return this.validFluids.stream().map(fluid -> new FluidStack(fluid, this.getInputConsumed())).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<FluidStack> getOutputs() {
        return this.getInputs();
    }

    @Override
    public FluidStack getOutput(TileEntityStillBase tile, FluidStack input) {
        FluidStack outputStack = input.copy();
        outputStack.amount = 1;
        this.modifyOutput(tile, outputStack);
        return outputStack;
    }

    public abstract void modifyOutput(TileEntityStillBase var1, FluidStack var2);

    @Override
    public void modifyTooltip(List<String> tooltip) {
        super.modifyTooltip(tooltip);
        tooltip.remove(1);
        tooltip.add(1, TextFormatting.LIGHT_PURPLE + Translator.translateToLocalFormatted((String)"distilling.effect.header", (Object[])new Object[0]));
    }

    public float getModifierOrDefault(String name, NBTTagCompound compound, FluidStack fluid) {
        return FluidUtil.getModifier(compound, fluid != null ? fluid.getFluid() : null, name);
    }
}

