/*
 * Decompiled with CFR 0.152.
 */
package soot.potion;

import java.awt.Color;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.Soot;
import soot.SoundEvents;
import soot.entity.EntityMuse;
import soot.network.PacketHandler;
import soot.network.message.MessageInspirationFX;
import soot.network.message.MessageMuseSpawnFX;
import soot.potion.PotionBase;
import soot.util.InspirationSound;

public class PotionInspiration
extends PotionBase {
    HashSet<UUID> affectedPlayers = new HashSet();
    boolean isAffected;

    public PotionInspiration() {
        super(false, new Color(64, 255, 32).getRGB());
        this.func_76390_b("effect.inspiration");
        this.func_76399_b(5, 0);
        this.func_188413_j();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_111185_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        super.func_111185_a(entityLivingBaseIn, attributeMapIn, amplifier);
        if (entityLivingBaseIn instanceof EntityPlayerMP) {
            boolean lastAffected = this.affectedPlayers.contains(entityLivingBaseIn.func_110124_au());
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageInspirationFX(lastAffected ? MessageInspirationFX.Type.Refresh : MessageInspirationFX.Type.Start), (EntityPlayerMP)entityLivingBaseIn);
        }
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        super.func_111187_a(entityLivingBaseIn, attributeMapIn, amplifier);
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        PotionEffect effect = entity.func_70660_b((Potion)this);
        assert (effect != null);
        int radius = 4;
        int duration = effect.func_76459_b();
        if (entity instanceof EntityPlayer) {
            Random rng = entity.func_70681_au();
            EntityPlayer player = (EntityPlayer)entity;
            if (duration % 5 == 0 && !entity.field_70170_p.field_72995_K) {
                player.func_71023_q(amplifier + 1);
            }
            if (duration % (20 * Math.max(15 - amplifier * 5, 5)) == 0 && !entity.field_70170_p.field_72995_K) {
                BlockPos blockpos = player.func_180425_c().func_177982_a(-radius + rng.nextInt(2 * radius + 1), 1, -radius + rng.nextInt(2 * radius + 1));
                EntityMuse muse = new EntityMuse(player.field_70170_p);
                muse.func_174828_a(blockpos, 0.0f, 0.0f);
                muse.setBoundPlayer(player);
                muse.setLimitedLife(600);
                player.field_70170_p.func_72838_d((Entity)muse);
                if (player instanceof EntityPlayerMP) {
                    PacketHandler.INSTANCE.sendTo((IMessage)new MessageMuseSpawnFX(muse.field_70165_t, muse.field_70163_u + (double)(muse.field_70131_O / 2.0f), muse.field_70161_v), (EntityPlayerMP)player);
                }
            }
        } else {
            entity.func_70604_c(null);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END || event.side == Side.CLIENT) {
            return;
        }
        EntityPlayer player = event.player;
        UUID uuid = player.func_110124_au();
        boolean lastAffected = this.affectedPlayers.contains(uuid);
        boolean isPotionActive = player.func_70644_a((Potion)this);
        if (isPotionActive && !lastAffected) {
            this.affectedPlayers.add(uuid);
        }
        if (!isPotionActive && lastAffected) {
            if (player instanceof EntityPlayerMP) {
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageInspirationFX(MessageInspirationFX.Type.Stop), (EntityPlayerMP)player);
            }
            this.affectedPlayers.remove(uuid);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END || event.side == Side.SERVER) {
            return;
        }
        EntityPlayer player = Soot.proxy.getMainPlayer();
        if (player == null) {
            return;
        }
        boolean isPotionActive = player.func_70644_a((Potion)this);
        if (!this.isAffected && isPotionActive) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new InspirationSound(player, SoundEvents.INSPIRATION_LOOP, SoundCategory.AMBIENT, 1.0f, 1.0f));
        }
        this.isAffected = isPotionActive;
    }
}

