/*
 * Decompiled with CFR 0.152.
 */
package soot.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import teamroots.embers.particle.ParticleUtil;

public class EntityCustomCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityCustomCloud.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityCustomCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNORE_RADIUS = EntityDataManager.func_187226_a(EntityCustomCloud.class, (DataSerializer)DataSerializers.field_187198_h);
    private final List<PotionEffect> effects = Lists.newArrayList();
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean colorSet;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private EntityLivingBase owner;
    private UUID ownerUniqueId;

    public EntityCustomCloud(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.setRadius(3.0f);
    }

    public EntityCustomCloud(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(IGNORE_RADIUS, (Object)false);
    }

    public void setRadius(float radiusIn) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.func_70105_a(radiusIn * 2.0f, 0.5f);
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    private void updateFixedColor() {
        if (this.effects.isEmpty()) {
            this.func_184212_Q().func_187227_b(COLOR, (Object)0);
        } else {
            this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(this.effects));
        }
    }

    public void addEffect(PotionEffect effect) {
        this.effects.add(effect);
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int colorIn) {
        this.colorSet = true;
        this.func_184212_Q().func_187227_b(COLOR, (Object)colorIn);
    }

    protected void setIgnoreRadius(boolean ignoreRadius) {
        this.func_184212_Q().func_187227_b(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    public boolean shouldIgnoreRadius() {
        return (Boolean)this.func_184212_Q().func_187225_a(IGNORE_RADIUS);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean ignoreRadius = this.shouldIgnoreRadius();
        float radius = this.getRadius();
        if (this.field_70170_p.field_72995_K) {
            if (!ignoreRadius || this.field_70146_Z.nextBoolean()) {
                float area = (float)Math.PI * radius * radius;
                int i = 0;
                while (true) {
                    float f = i;
                    float f2 = ignoreRadius ? 2.0f : area;
                    if (f < f2) {
                        float angle = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float distance = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * (ignoreRadius ? 0.2f : radius);
                        float offsetX = MathHelper.func_76134_b((float)angle) * distance;
                        float offsetZ = MathHelper.func_76126_a((float)angle) * distance;
                        float velX = (0.5f - this.field_70146_Z.nextFloat()) * 0.05f;
                        float velY = this.field_70146_Z.nextFloat() * 0.05f;
                        float velZ = (0.5f - this.field_70146_Z.nextFloat()) * 0.05f;
                        int color = this.getColor();
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        int a = color >> 24 & 0xFF;
                        ParticleUtil.spawnParticleVapor((World)this.field_70170_p, (float)((float)this.field_70165_t + offsetX), (float)((float)this.field_70163_u), (float)((float)this.field_70161_v + offsetZ), (float)velX, (float)velY, (float)velZ, (float)r, (float)g, (float)b, (float)a, (float)2.0f, (float)5.0f, (int)50);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            boolean notTriggered;
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            boolean bl = notTriggered = this.field_70173_aa < this.waitTime;
            if (ignoreRadius != notTriggered) {
                this.setIgnoreRadius(notTriggered);
            }
            if (notTriggered) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(radius);
            }
            if (this.field_70173_aa % 5 == 0) {
                this.CheckReapply();
                List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
                if (!list.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list) {
                        boolean hit;
                        double distZ;
                        double distX;
                        double distance;
                        if (this.reapplicationDelayMap.containsKey(entitylivingbase) || !((distance = (distX = entitylivingbase.field_70165_t - this.field_70165_t) * distX + (distZ = entitylivingbase.field_70161_v - this.field_70161_v) * distZ) <= (double)(radius * radius)) || !(hit = this.applyEffectToEntity(entitylivingbase))) continue;
                        if (this.radiusOnUse != 0.0f) {
                            if ((radius += this.radiusOnUse) < 0.5f) {
                                this.func_70106_y();
                                return;
                            }
                            this.setRadius(radius);
                        }
                        if (this.durationOnUse == 0) continue;
                        this.duration += this.durationOnUse;
                        if (this.duration > 0) continue;
                        this.func_70106_y();
                        return;
                    }
                }
            }
        }
    }

    public void CheckReapply() {
        Iterator<Map.Entry<Entity, Integer>> iterator = this.reapplicationDelayMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Integer> entry = iterator.next();
            if (this.field_70173_aa < entry.getValue()) continue;
            iterator.remove();
        }
    }

    public boolean applyEffectToEntity(EntityLivingBase entitylivingbase) {
        if (!entitylivingbase.func_184603_cC()) {
            return false;
        }
        this.reapplicationDelayMap.put((Entity)entitylivingbase, this.field_70173_aa + this.reapplicationDelay);
        for (PotionEffect potioneffect : this.effects) {
            if (potioneffect.func_188419_a().func_76403_b()) {
                potioneffect.func_188419_a().func_180793_a((Entity)this, (Entity)this.getOwner(), entitylivingbase, potioneffect.func_76458_c(), 0.5);
                continue;
            }
            entitylivingbase.func_70690_d(new PotionEffect(potioneffect));
        }
        return true;
    }

    public void setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
    }

    public void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    public void setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
    }

    public void setOwner(@Nullable EntityLivingBase ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.ownerUniqueId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
        return this.owner;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.waitTime = compound.func_74762_e("WaitTime");
        this.reapplicationDelay = compound.func_74762_e("ReapplicationDelay");
        this.durationOnUse = compound.func_74762_e("DurationOnUse");
        this.radiusOnUse = compound.func_74760_g("RadiusOnUse");
        this.radiusPerTick = compound.func_74760_g("RadiusPerTick");
        this.setRadius(compound.func_74760_g("Radius"));
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
        if (compound.func_150297_b("Color", 99)) {
            this.setColor(compound.func_74762_e("Color"));
        }
        if (compound.func_150297_b("Effects", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)nbttaglist.func_150305_b(i));
                this.addEffect(potioneffect);
            }
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("WaitTime", this.waitTime);
        compound.func_74768_a("ReapplicationDelay", this.reapplicationDelay);
        compound.func_74768_a("DurationOnUse", this.durationOnUse);
        compound.func_74776_a("RadiusOnUse", this.radiusOnUse);
        compound.func_74776_a("RadiusPerTick", this.radiusPerTick);
        compound.func_74776_a("Radius", this.getRadius());
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
        if (this.colorSet) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.effects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("Effects", (NBTBase)nbttaglist);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
        }
        super.func_184206_a(key);
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

