/*
 * Decompiled with CFR 0.152.
 */
package soot.compat.jei.category;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import soot.compat.jei.wrapper.StillWrapper;

public class StillCategory
implements IRecipeCategory<StillWrapper> {
    public static final int WIDTH = 73;
    public static final int HEIGHT = 71;
    public static final String UID = "embers.still";
    public static final String L18N_KEY = "embers.jei.recipe.still";
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;

    public StillCategory(IGuiHelper helper) {
        ResourceLocation location = new ResourceLocation("soot", "textures/gui/jei_still.png");
        this.background = helper.createDrawable(location, 0, 0, 73, 71);
        this.localizedName = Translator.translateToLocal((String)L18N_KEY);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Soot";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, StillWrapper recipeWrapper, IIngredients ingredients) {
        IGuiFluidStackGroup fluid = recipeLayout.getFluidStacks();
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        fluid.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (ingredient != null) {
                tooltip.remove(1);
                tooltip.add(1, Translator.translateToLocalFormatted((String)"jei.tooltip.liquid.amount", (Object[])new Object[]{ingredient.amount}));
            }
            if (slotIndex == 1) {
                recipeWrapper.modifyTooltip(tooltip);
            }
        });
        fluid.init(0, true, 8, 28, 16, 16, 1, true, null);
        fluid.init(1, true, 49, 28, 16, 16, 1, true, null);
        fluid.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        fluid.set(1, (List)ingredients.getOutputs(FluidStack.class).get(0));
        stacks.init(0, true, 48, 3);
        List outputStacks = ingredients.getInputs(ItemStack.class);
        if (outputStacks.size() > 0) {
            stacks.set(0, (List)outputStacks.get(0));
        }
    }
}

