/*
 * Decompiled with CFR 0.152.
 */
package soot.compat.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;
import soot.recipe.CraftingRegistry;
import soot.recipe.RecipeAlchemicalMixer;
import soot.util.CTUtil;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.value.IntRange;
import teamroots.embers.api.alchemy.AspectList;

@ZenRegister
@ZenClass(value="mods.soot.AlchemicalMixer")
public class AlchemicalMixer {
    public static final String clazz = "mods.soot.AlchemicalMixer";

    @ZenMethod
    public static void add(ILiquidStack output, @NotNull ILiquidStack[] inputs, IntRange iron, IntRange copper, IntRange lead, IntRange silver, IntRange dawnstone) {
        AlchemicalMixer.addInternal(output, inputs, CTUtil.toAspectRange(iron, copper, lead, silver, dawnstone));
    }

    @ZenMethod
    public static void add(ILiquidStack output, @NotNull ILiquidStack[] inputs, Map<String, IntRange> aspects) {
        AspectList minAspects = new AspectList();
        AspectList maxAspects = new AspectList();
        for (Map.Entry<String, IntRange> entry : aspects.entrySet()) {
            String aspect = entry.getKey();
            minAspects.addAspect(aspect, entry.getValue().getFrom());
            maxAspects.addAspect(aspect, entry.getValue().getTo());
        }
        AlchemicalMixer.addInternal(output, inputs, new AspectList.AspectRangeList(minAspects, maxAspects));
    }

    private static void addInternal(ILiquidStack output, @NotNull ILiquidStack[] inputs, AspectList.AspectRangeList aspects) {
        RecipeAlchemicalMixer recipe = new RecipeAlchemicalMixer(InputHelper.toFluids((ILiquidStack[])inputs), InputHelper.toFluid((ILiquidStack)output), aspects);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(ILiquidStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(InputHelper.toFluid((ILiquidStack)output)));
    }

    private static List<RecipeAlchemicalMixer> getRecipesByOutput(FluidStack stack) {
        return CraftingRegistry.alchemicalMixingRecipes.stream().filter(recipe -> recipe.output.isFluidStackIdentical(stack)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class Remove
    extends BaseListRemoval<RecipeAlchemicalMixer> {
        protected Remove(FluidStack input) {
            super("AlchemicalMixer", CraftingRegistry.alchemicalMixingRecipes, AlchemicalMixer.getRecipesByOutput(input));
        }

        protected String getRecipeInfo(RecipeAlchemicalMixer recipe) {
            return ((Object)((Object)recipe)).toString();
        }
    }

    public static class Add
    extends BaseListAddition<RecipeAlchemicalMixer> {
        public Add(RecipeAlchemicalMixer recipe) {
            super("AlchemicalMixer", CraftingRegistry.alchemicalMixingRecipes, (List)Lists.newArrayList((Object[])new RecipeAlchemicalMixer[]{recipe}));
        }

        protected String getRecipeInfo(RecipeAlchemicalMixer recipe) {
            return ((Object)((Object)recipe)).toString();
        }
    }
}

