/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import thut.lib.CompatClass;

public class CompatParser {
    public static void findClasses(String classPackage, Map<CompatClass.Phase, Set<Method>> initMethods) {
        try {
            List<Class<?>> foundClasses = ClassFinder.find(classPackage);
            for (Class<?> c : foundClasses) {
                try {
                    CompatClass comp = null;
                    for (Method m : c.getMethods()) {
                        comp = m.getAnnotation(CompatClass.class);
                        if (comp == null) continue;
                        initMethods.get((Object)comp.phase()).add(m);
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static class ClassFinder {
        private static final char DOT = '.';
        private static final char SLASH = '/';
        private static final String CLASS_SUFFIX = ".class";
        private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the package '%s' exists?";

        public static List<Class<?>> find(String scannedPackage) throws UnsupportedEncodingException {
            String scannedPath = scannedPackage.replace('.', '/');
            URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
            if (scannedUrl == null) {
                throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage));
            }
            File scannedDir = new File(URLDecoder.decode(scannedUrl.getFile(), Charset.defaultCharset().name()));
            HashSet classes = Sets.newHashSet();
            classes.addAll(ClassFinder.findInFolder(new File("./mods/"), scannedPackage));
            if (scannedDir.exists()) {
                for (File file : scannedDir.listFiles()) {
                    classes.addAll(ClassFinder.findInFolder(file, scannedPackage));
                }
            }
            return Lists.newArrayList((Iterable)classes);
        }

        private static List<Class<?>> findInFolder(File file, String scannedPackage) {
            ArrayList classes;
            block10: {
                String resource;
                block11: {
                    block9: {
                        classes = new ArrayList();
                        if (!file.toString().endsWith(".jar")) break block9;
                        try {
                            String name = file.toString();
                            String pack = scannedPackage.replace('.', '/') + '/';
                            name = name.replace("file:", "");
                            name = name.replaceAll("(.jar)(.*)", ".jar");
                            file = new File(name);
                            ZipFile zip = new ZipFile(file);
                            Enumeration<? extends ZipEntry> entries = zip.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                String s = entry.getName();
                                if (!s.startsWith(pack) || !s.endsWith(CLASS_SUFFIX)) continue;
                                try {
                                    classes.add(Class.forName(s.replace(CLASS_SUFFIX, "").replace('/', '.')));
                                }
                                catch (Throwable throwable) {}
                            }
                            zip.close();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        break block10;
                    }
                    resource = file.toString().replaceAll("\\" + System.getProperty("file.separator"), ".");
                    if (resource.indexOf(scannedPackage) != -1) {
                        resource = resource.substring(resource.indexOf(scannedPackage), resource.length());
                    }
                    if (!file.isDirectory()) break block11;
                    for (File child : file.listFiles()) {
                        classes.addAll(ClassFinder.findInFolder(child, scannedPackage));
                    }
                    break block10;
                }
                if (!resource.endsWith(CLASS_SUFFIX)) break block10;
                int endIndex = resource.length() - CLASS_SUFFIX.length();
                String className = resource.substring(0, endIndex);
                try {
                    classes.add(Class.forName(className));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return classes;
        }
    }
}

