/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.tabula.animation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.w3c.dom.NamedNodeMap;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class BasicFlapAnimation
extends Animation {
    public BasicFlapAnimation() {
        this.loops = true;
        this.name = "flying";
    }

    @Override
    public Animation init(NamedNodeMap map, @Nullable AnimationRegistry.IPartRenamer renamer) {
        HashSet<String> hl = new HashSet<String>();
        HashSet<String> hr = new HashSet<String>();
        int flapdur = 0;
        int flapaxis = 2;
        float walkAngle1 = 20.0f;
        float walkAngle2 = 20.0f;
        String[] lh = map.getNamedItem("leftWing").getNodeValue().split(":");
        String[] rh = map.getNamedItem("rightWing").getNodeValue().split(":");
        if (renamer != null) {
            renamer.convertToIdents(lh);
            renamer.convertToIdents(rh);
        }
        for (String s : lh) {
            if (s == null) continue;
            hl.add(s);
        }
        for (String s : rh) {
            if (s == null) continue;
            hr.add(s);
        }
        if (map.getNamedItem("angle") != null) {
            walkAngle1 = Float.parseFloat(map.getNamedItem("angle").getNodeValue());
        }
        if (map.getNamedItem("start") != null) {
            walkAngle2 = Float.parseFloat(map.getNamedItem("start").getNodeValue());
        }
        if (map.getNamedItem("axis") != null) {
            flapaxis = Integer.parseInt(map.getNamedItem("axis").getNodeValue());
        }
        flapdur = Integer.parseInt(map.getNamedItem("duration").getNodeValue());
        this.init(hl, hr, flapdur, walkAngle1, walkAngle2, flapaxis);
        return this;
    }

    public BasicFlapAnimation init(Set<String> lw, Set<String> rw, int duration, float angle, float start, int axis) {
        ArrayList set;
        AnimationComponent component3;
        AnimationComponent component2;
        AnimationComponent component1;
        String ident;
        duration += duration % 4;
        for (String s : rw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = -start;
            component1.rotChange[axis] = angle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = -2.0f * angle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = angle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : lw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = start;
            component1.rotChange[axis] = -angle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = 2.0f * angle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = -angle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        return this;
    }
}

