/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import thut.api.boom.ExplosionCustom;
import thut.api.maths.Cruncher;

public class Checker {
    final ExplosionCustom boom;

    public Checker(ExplosionCustom boom) {
        this.boom = boom;
    }

    private ExplosionCustom.BlastResult getBlocksToRemove2() {
        int ind = this.boom.currentIndex;
        double scaleFactor = 1500.0;
        int num = (int)Math.sqrt((double)this.boom.strength * scaleFactor / 0.5);
        int max = this.boom.radius * 2 + 1;
        num = Math.min(num, max);
        num = Math.min(num, 1000);
        int numCubed = num * num * num;
        double radSq = num * num / 4;
        int maxIndex = numCubed;
        int increment = 0;
        ArrayList ret = Lists.newArrayList();
        ArrayList entityAffected = Lists.newArrayList();
        boolean done = true;
        long start = System.currentTimeMillis();
        this.boom.currentIndex = ind;
        while (this.boom.currentIndex < maxIndex) {
            double rSq;
            ++increment;
            long time = System.currentTimeMillis();
            if (time - start > 100L) {
                done = false;
                break;
            }
            Cruncher.indexToVals(this.boom.currentIndex, this.boom.r);
            if (!(this.boom.r.y + this.boom.centre.y < 0.0 || this.boom.r.y + this.boom.centre.y > 255.0 || (rSq = this.boom.r.magSq()) > radSq)) {
                double rMag = Math.sqrt(rSq);
                this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
                this.boom.rHat.set(this.boom.r).norm();
                int index = Cruncher.getVectorInt(this.boom.rHat.scalarMultBy((double)num / 2.0));
                this.boom.rHat.scalarMultBy(2.0 / (double)num);
                if (!this.boom.blockedSet.contains(index)) {
                    double str = (double)this.boom.strength * scaleFactor / rSq;
                    if (this.boom.rAbs.isAir((IBlockAccess)this.boom.field_77287_j) && !this.boom.r.isEmpty()) {
                        List hits;
                        if (ExplosionCustom.AFFECTINAIR && (hits = this.boom.field_77287_j.func_72839_b(this.boom.field_77283_e, this.boom.rAbs.getAABB().func_72314_b(0.5, 0.5, 0.5))) != null) {
                            for (Entity e : hits) {
                                entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
                            }
                        }
                    } else {
                        if (str <= (double)this.boom.minBlastDamage) {
                            System.out.println("Terminating at distance " + rMag);
                            done = true;
                            break;
                        }
                        if (!this.boom.canBreak(this.boom.rAbs)) {
                            this.boom.blockedSet.add(index);
                        } else {
                            float res = this.boom.rAbs.getExplosionResistance(this.boom, (IBlockAccess)this.boom.field_77287_j);
                            if (res > 1.0f) {
                                res *= res;
                            }
                            int index2 = Cruncher.getVectorInt(this.boom.r);
                            this.boom.resists.put(index2, Float.valueOf(res));
                            this.boom.checked.set(index2);
                            if ((double)res > str) {
                                this.boom.blockedSet.add(index);
                            } else {
                                boolean stop = false;
                                rMag = this.boom.r.mag();
                                float dj = 1.0f;
                                float resist = 0.0f;
                                float j = 0.0f;
                                while ((double)j <= rMag) {
                                    this.boom.rTest.set(this.boom.rHat).scalarMultBy(j);
                                    if (!this.boom.rTest.sameBlock(this.boom.rTestPrev)) {
                                        this.boom.rTestAbs.set(this.boom.rTest).addTo(this.boom.centre);
                                        index2 = Cruncher.getVectorInt(this.boom.rTest);
                                        if (this.boom.checked.get(index2)) {
                                            res = this.boom.resists.get(index2).floatValue();
                                        } else {
                                            res = this.boom.rTestAbs.getExplosionResistance(this.boom, (IBlockAccess)this.boom.field_77287_j);
                                            if (res > 1.0f) {
                                                res *= res;
                                            }
                                            this.boom.resists.put(index2, Float.valueOf(res));
                                            this.boom.checked.set(index2);
                                        }
                                        resist += res;
                                        if (!this.boom.canBreak(this.boom.rTestAbs)) {
                                            stop = true;
                                            this.boom.blockedSet.add(index);
                                            break;
                                        }
                                        double d1 = this.boom.rTest.magSq();
                                        double d = d1;
                                        str = (double)this.boom.strength * scaleFactor / d;
                                        if ((double)resist > str) {
                                            stop = true;
                                            this.boom.blockedSet.add(index);
                                            break;
                                        }
                                    }
                                    this.boom.rTestPrev.set(this.boom.rTest);
                                    j += dj;
                                }
                                if (!stop) {
                                    this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
                                    Chunk chunk = this.boom.field_77287_j.func_175726_f(this.boom.rAbs.getPos());
                                    if (chunk == null) {
                                        System.out.println("No chunk at " + this.boom.rAbs);
                                        Thread.dumpStack();
                                    }
                                    if (!this.boom.affected.contains(chunk)) {
                                        this.boom.affected.add(chunk);
                                    }
                                    this.boom.addChunkPosition(this.boom.rAbs);
                                    List hits = this.boom.field_77287_j.func_72839_b(this.boom.field_77283_e, this.boom.rAbs.getAABB().func_72314_b(0.5, 0.5, 0.5));
                                    if (hits != null) {
                                        for (Entity e : hits) {
                                            entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
                                        }
                                    }
                                    ret.add(new BlockPos((Vec3i)this.boom.rAbs.getPos()));
                                }
                            }
                        }
                    }
                }
            }
            ++this.boom.currentIndex;
        }
        this.boom.nextIndex = this.boom.currentIndex + increment;
        return new ExplosionCustom.BlastResult(ret, entityAffected, done);
    }

    protected ExplosionCustom.BlastResult getBlocksToRemove() {
        int thisIndex;
        boolean oldBoom = true;
        if (oldBoom) {
            return this.getBlocksToRemove2();
        }
        int ind = this.boom.currentIndex;
        this.boom.centre.set(this.boom.centre.getPos()).addTo(0.5, 0.5, 0.5);
        double scaleFactor = 1500.0;
        int num = (int)Math.sqrt((double)this.boom.strength * scaleFactor / 0.5);
        int max = this.boom.radius * 2 + 1;
        num = Math.min(num, max);
        num = Math.min(num, 1000);
        int numCubed = num * num * num;
        double radSq = num * num / 4;
        int currentRadius = (int)Math.floor(Cruncher.cubeRoot(this.boom.currentIndex));
        currentRadius = (currentRadius - 1) / 2 + 1;
        int maxIndex = numCubed;
        int increment = 0;
        ArrayList ret = Lists.newArrayList();
        ArrayList entityAffected = Lists.newArrayList();
        boolean done = maxIndex >= numCubed;
        long start = System.currentTimeMillis();
        int n = 0;
        int nh = 0;
        int noH = 0;
        int pre = 0;
        HashSet test = Sets.newHashSet();
        for (int i = 0; i < 125; ++i) {
            Cruncher.indexToVals(i, this.boom.r);
            thisIndex = Cruncher.getVectorInt(this.boom.r);
            test.add(thisIndex);
        }
        this.boom.currentIndex = ind;
        while (this.boom.currentIndex < maxIndex) {
            ++n;
            ++increment;
            long time = System.currentTimeMillis();
            if (time - start > 50L) {
                done = false;
                break;
            }
            Cruncher.indexToVals(this.boom.currentIndex, this.boom.r);
            thisIndex = Cruncher.getVectorInt(this.boom.r);
            int cr = (int)Math.floor(Cruncher.cubeRoot(this.boom.currentIndex));
            cr = (cr - 1) / 2 + 1;
            if (currentRadius != cr) {
                currentRadius = cr;
                System.out.println(this.boom.thisShell.size() - pre + " layer:" + n + " found:" + nh + " notFound:" + noH + " total:" + (nh + noH));
                n = 0;
                nh = 0;
                noH = 0;
                pre = this.boom.thisShell.size();
            }
            if (this.boom.r.y + this.boom.centre.y < 0.0 || this.boom.r.y + this.boom.centre.y > 255.0) {
                this.boom.thisShell.put(thisIndex, (Object)new Float(2.1474836E9f));
            } else {
                double rSq = this.boom.r.magSq();
                if (rSq > radSq || this.boom.thisShell.containsKey(thisIndex)) {
                    if (!(rSq > radSq)) {
                        System.out.println("invalid " + this.boom.r);
                    }
                    this.boom.thisShell.put(thisIndex, (Object)new Float(2.1474836E9f));
                } else {
                    float resHere;
                    double rMag = Math.sqrt(rSq);
                    this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
                    this.boom.rHat.set(this.boom.r).norm();
                    double str = (double)this.boom.strength * scaleFactor / rSq;
                    if (str <= (double)this.boom.minBlastDamage) {
                        System.out.println("Terminating at distance " + rMag);
                        done = true;
                        break;
                    }
                    float f = resHere = !this.boom.canBreak(this.boom.rAbs) ? 2.1474836E9f : this.boom.rAbs.getExplosionResistance(this.boom, (IBlockAccess)this.boom.field_77287_j);
                    if (resHere > 1.0f) {
                        resHere *= resHere;
                    }
                    if ((double)resHere > str) {
                        this.boom.thisShell.put(thisIndex, (Object)new Float(2.1474836E9f));
                    } else {
                        boolean stop = false;
                        rMag = this.boom.r.mag();
                        float dj = 0.5f;
                        float res = resHere;
                        this.boom.rTestPrev.set(this.boom.r);
                        for (float j = (float)rMag; j > 0.0f; j -= dj) {
                            this.boom.rTest.set(this.boom.rHat).scalarMultBy(j);
                            if (!this.boom.rTest.sameBlock(this.boom.rTestPrev)) {
                                this.boom.rTestAbs.set(this.boom.rTest).addTo(this.boom.centre);
                                int coordIndex = Cruncher.getVectorInt(this.boom.rTest);
                                boolean has = this.boom.thisShell.containsKey(coordIndex);
                                float old = has ? ((Float)this.boom.thisShell.get(coordIndex)).floatValue() : this.boom.rTestAbs.getExplosionResistance(this.boom, (IBlockAccess)this.boom.field_77287_j);
                                res += old;
                                if (has) {
                                    ++nh;
                                } else {
                                    ++noH;
                                }
                                if (!this.boom.canBreak(this.boom.rTestAbs) || (double)res > str) {
                                    stop = true;
                                    break;
                                }
                            }
                            this.boom.rTestPrev.set(this.boom.rTest);
                        }
                        if (stop) {
                            this.boom.thisShell.put(thisIndex, (Object)new Float(2.1474836E9f));
                        } else {
                            this.boom.thisShell.put(thisIndex, (Object)new Float(resHere));
                            this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
                            Chunk chunk = this.boom.field_77287_j.func_175726_f(this.boom.rAbs.getPos());
                            if (chunk == null) {
                                System.out.println("No chunk at " + this.boom.rAbs);
                                Thread.dumpStack();
                            }
                            if (!this.boom.affected.contains(chunk)) {
                                this.boom.affected.add(chunk);
                            }
                            this.boom.addChunkPosition(this.boom.rAbs);
                            List hits = this.boom.field_77287_j.func_72839_b(this.boom.field_77283_e, this.boom.rAbs.getAABB().func_72314_b(0.5, 0.5, 0.5));
                            if (hits != null) {
                                for (Entity e : hits) {
                                    entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
                                }
                            }
                            ret.add(new BlockPos((Vec3i)this.boom.rAbs.getPos()));
                        }
                    }
                }
            }
            ++this.boom.currentIndex;
        }
        this.boom.nextIndex = this.boom.currentIndex + increment;
        return new ExplosionCustom.BlastResult(ret, entityAffected, done);
    }
}

