/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.blay09.mods.cookingforblockheads.ModConfig;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.client.gui.GuiButtonSort;
import net.blay09.mods.cookingforblockheads.container.ContainerRecipeBook;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotCraftMatrix;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotRecipe;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.api.MouseTweaksIgnore;

@MouseTweaksIgnore
public class GuiRecipeBook
extends GuiContainer {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final ResourceLocation guiTexture = new ResourceLocation("cookingforblockheads", "textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private final ContainerRecipeBook container;
    private boolean isEventHandler;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private GuiButton btnNextRecipe;
    private GuiButton btnPrevRecipe;
    private GuiTextField searchBar;
    private final List<GuiButtonSort> sortButtons = Lists.newArrayList();
    private final String[] noIngredients;
    private final String[] noSelection;

    public GuiRecipeBook(ContainerRecipeBook container) {
        super((Container)container);
        this.container = container;
        this.noIngredients = I18n.func_135052_a((String)"gui.cookingforblockheads:no_ingredients", (Object[])new Object[0]).split("\\\\n");
        this.noSelection = I18n.func_135052_a((String)"gui.cookingforblockheads:no_selection", (Object[])new Object[0]).split("\\\\n");
    }

    public void func_73866_w_() {
        this.field_147000_g = 174;
        super.func_73866_w_();
        this.btnPrevRecipe = new GuiButton(0, this.field_146294_l / 2 - 79, this.field_146295_m / 2 - 51, 13, 20, "<");
        this.btnPrevRecipe.field_146125_m = false;
        this.field_146292_n.add(this.btnPrevRecipe);
        this.btnNextRecipe = new GuiButton(1, this.field_146294_l / 2 - 9, this.field_146295_m / 2 - 51, 13, 20, ">");
        this.btnNextRecipe.field_146125_m = false;
        this.field_146292_n.add(this.btnNextRecipe);
        this.searchBar = new GuiTextField(2, this.field_146289_q, this.field_147003_i + this.field_146999_f - 78, this.field_147009_r - 5, 70, 10);
        int yOffset = -80;
        int id = 3;
        for (ISortButton button : CookingRegistry.getSortButtons()) {
            GuiButtonSort sortButton = new GuiButtonSort(id++, this.field_146294_l / 2 + 87, this.field_146295_m / 2 + yOffset, button);
            this.field_146292_n.add(sortButton);
            this.sortButtons.add(sortButton);
            yOffset += 20;
        }
        if (!this.isEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.isEventHandler = true;
        }
        this.recalculateScrollBar();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.btnPrevRecipe) {
            this.container.nextSubRecipe(-1);
        } else if (button == this.btnNextRecipe) {
            this.container.nextSubRecipe(1);
        }
        for (GuiButton guiButton : this.sortButtons) {
            if (!(guiButton instanceof GuiButtonSort) || button != guiButton) continue;
            this.container.setSortComparator(((GuiButtonSort)guiButton).getComparator((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta == 0) {
            return;
        }
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.container.getSelection() != null && mouseX >= this.field_147003_i + 7 && mouseY >= this.field_147009_r + 17 && mouseX < this.field_147003_i + 92 && mouseY < this.field_147009_r + 95) {
            Slot slot = this.getSlotUnderMouse();
            if (slot instanceof FakeSlotCraftMatrix && ((FakeSlotCraftMatrix)slot).getVisibleStacks().size() > 1) {
                ((FakeSlotCraftMatrix)slot).scrollDisplayList(delta > 0 ? -1 : 1);
            }
        } else {
            this.setCurrentOffset(delta > 0 ? this.currentOffset - 1 : this.currentOffset + 1);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        Slot mouseSlot;
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1 && mouseX >= this.searchBar.field_146209_f && mouseX < this.searchBar.field_146209_f + this.searchBar.field_146218_h && mouseY >= this.searchBar.field_146210_g && mouseY < this.searchBar.field_146210_g + this.searchBar.field_146219_i) {
            this.searchBar.func_146180_a("");
            this.container.search(null);
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
        } else {
            this.searchBar.func_146192_a(mouseX, mouseY, button);
        }
        if (mouseX >= this.scrollBarXPos && mouseX <= this.scrollBarXPos + 7 && mouseY >= this.scrollBarYPos && mouseY <= this.scrollBarYPos + this.scrollBarScaledHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
        if ((mouseSlot = this.getSlotUnderMouse()) instanceof FakeSlotCraftMatrix) {
            if (button == 0) {
                ItemStack itemStack = mouseSlot.func_75211_c();
                FoodRecipeWithStatus recipe = this.container.findAvailableRecipe(itemStack);
                if (recipe != null) {
                    this.container.setSelectedRecipe(recipe, false);
                    this.setCurrentOffset(this.container.getSelectedRecipeIndex());
                } else if (!CookingRegistry.getFoodRecipes(itemStack).isEmpty()) {
                    this.container.setSelectedRecipe(new FoodRecipeWithStatus(itemStack, RecipeStatus.MISSING_INGREDIENTS), true);
                }
            } else if (button == 1) {
                ((FakeSlotCraftMatrix)mouseSlot).setLocked(!((FakeSlotCraftMatrix)mouseSlot).isLocked());
            }
        }
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (this.searchBar.func_146201_a(c, keyCode)) {
            this.container.search(this.searchBar.func_146179_b());
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
        } else {
            super.func_73869_a(c, keyCode);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        FoodRecipeWithIngredients selection;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isDirty()) {
            this.setCurrentOffset(this.currentOffset);
            this.container.setDirty(false);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r - 10, 0, 0, this.field_146999_f, this.field_147000_g + 10);
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnPrevRecipe.field_146125_m = this.container.hasVariants();
        this.btnPrevRecipe.field_146124_l = this.container.getSelectionIndex() > 0;
        this.btnNextRecipe.field_146125_m = this.container.hasVariants();
        this.btnNextRecipe.field_146124_l = this.container.getSelectionIndex() < this.container.getRecipeCount() - 1;
        boolean hasRecipes = this.container.getItemListCount() > 0;
        for (GuiButton guiButton : this.sortButtons) {
            guiButton.field_146124_l = hasRecipes;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ModConfig.client.showIngredientIcon) {
            float prevZLevel = this.field_73735_i;
            this.field_73735_i = 300.0f;
            for (Slot slot : this.field_147002_h.field_75151_b) {
                FoodRecipeWithStatus recipe;
                if (!(slot instanceof FakeSlotRecipe)) continue;
                if (CookingRegistry.isNonFoodRecipe(slot.func_75211_c())) {
                    this.func_73729_b(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 176, 76, 16, 16);
                }
                if ((recipe = ((FakeSlotRecipe)slot).getRecipe()) == null || recipe.getStatus() != RecipeStatus.MISSING_TOOLS) continue;
                this.func_73729_b(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 176, 92, 16, 16);
            }
            this.field_73735_i = prevZLevel;
        }
        if ((selection = this.container.getSelection()) == null) {
            int n = this.field_147009_r + 39 - this.noSelection.length / 2 * this.field_146289_q.field_78288_b;
            String[] stringArray = this.noSelection;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                void var6_14;
                String s = stringArray[i];
                this.field_146289_q.func_175063_a(s, (float)(this.field_147003_i + 23 + 27) - (float)this.field_146289_q.func_78256_a(s) / 2.0f, (float)var6_14, -1);
                var6_14 += this.field_146289_q.field_78288_b + 5;
            }
        } else if (selection.getRecipeType() == RecipeType.SMELTING) {
            this.func_73729_b(this.field_147003_i + 23, this.field_147009_r + 19, 54, 184, 54, 54);
        } else {
            this.func_73729_b(this.field_147003_i + 23, this.field_147009_r + 19, 0, 184, 54, 54);
        }
        if (selection != null) {
            for (FakeSlotCraftMatrix fakeSlotCraftMatrix : this.container.getCraftingMatrixSlots()) {
                if (!fakeSlotCraftMatrix.isLocked() || fakeSlotCraftMatrix.getVisibleStacks().size() <= 1) continue;
                this.func_73729_b(this.field_147003_i + fakeSlotCraftMatrix.field_75223_e, this.field_147009_r + fakeSlotCraftMatrix.field_75221_f, 176, 60, 16, 16);
            }
        }
        GuiContainer.func_73734_a((int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        if (this.container.getItemListCount() == 0) {
            GuiContainer.func_73734_a((int)(this.field_147003_i + 97), (int)(this.field_147009_r + 7), (int)(this.field_147003_i + 168), (int)(this.field_147009_r + 85), (int)-1440603614);
            int n = this.field_147009_r + 39 - this.noIngredients.length / 2 * this.field_146289_q.field_78288_b;
            for (String s : this.noIngredients) {
                void var6_17;
                this.field_146289_q.func_175063_a(s, (float)(this.field_147003_i + 97 + 36) - (float)this.field_146289_q.func_78256_a(s) / 2.0f, (float)var6_17, -1);
                var6_17 += this.field_146289_q.field_78288_b + 5;
            }
        }
        this.searchBar.func_146194_f();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        float prevZLevel = this.field_73735_i;
        this.field_73735_i = 300.0f;
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof FakeSlotCraftMatrix) || ((FakeSlotCraftMatrix)slot).isAvailable() || slot.func_75211_c().func_190926_b()) continue;
            this.func_73733_a(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, this.field_147003_i + slot.field_75223_e + 16, this.field_147009_r + slot.field_75221_f + 16, 0x77FF4444, 0x77FF5555);
        }
        this.field_73735_i = prevZLevel;
        this.container.updateSlots(partialTicks);
        for (GuiButton guiButton : this.sortButtons) {
            if (!(guiButton instanceof GuiButtonSort) || !guiButton.func_146115_a() || !guiButton.field_146124_l) continue;
            this.func_146283_a(((GuiButtonSort)guiButton).getTooltipLines(), mouseX, mouseY);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.isEventHandler) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.isEventHandler = false;
        }
    }

    public void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getItemListCount() / 3.0f)));
        this.scrollBarXPos = this.field_147003_i + this.field_146999_f - 7 - 9;
        this.scrollBarYPos = this.field_147009_r + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4);
    }

    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Slot hoverSlot = this.getSlotUnderMouse();
        if (hoverSlot instanceof FakeSlotRecipe && event.getItemStack() == hoverSlot.func_75211_c()) {
            FakeSlotRecipe slotRecipe = (FakeSlotRecipe)hoverSlot;
            if (this.container.isSelectedSlot(slotRecipe) && this.container.isAllowCrafting()) {
                FoodRecipeWithIngredients subRecipe = this.container.getSelection();
                if (subRecipe == null) {
                    return;
                }
                if (subRecipe.getRecipeType() == RecipeType.SMELTING) {
                    if (!this.container.hasOven()) {
                        event.getToolTip().add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.cookingforblockheads:missing_oven", (Object[])new Object[0]));
                    } else if (GuiRecipeBook.func_146272_n()) {
                        event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:click_to_smelt_stack", (Object[])new Object[0]));
                    } else {
                        event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:click_to_smelt_one", (Object[])new Object[0]));
                    }
                } else if (subRecipe.getRecipeStatus() == RecipeStatus.MISSING_TOOLS) {
                    event.getToolTip().add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.cookingforblockheads:missing_tools", (Object[])new Object[0]));
                } else if (subRecipe.getRecipeStatus() == RecipeStatus.MISSING_INGREDIENTS) {
                    event.getToolTip().add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.cookingforblockheads:missing_ingredients", (Object[])new Object[0]));
                } else if (GuiRecipeBook.func_146272_n()) {
                    event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:click_to_craft_stack", (Object[])new Object[0]));
                } else {
                    event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:click_to_craft_one", (Object[])new Object[0]));
                }
            } else {
                event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cookingforblockheads:click_to_see_recipe", (Object[])new Object[0]));
            }
        } else if (hoverSlot instanceof FakeSlotCraftMatrix && event.getItemStack() == hoverSlot.func_75211_c() && ((FakeSlotCraftMatrix)hoverSlot).getVisibleStacks().size() > 1) {
            if (((FakeSlotCraftMatrix)hoverSlot).isLocked()) {
                event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:click_to_unlock", (Object[])new Object[0]));
            } else {
                event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:click_to_lock", (Object[])new Object[0]));
            }
            event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cookingforblockheads:scroll_to_switch", (Object[])new Object[0]));
        }
    }

    public GuiButton[] getSortingButtons() {
        return this.sortButtons.toArray(new GuiButton[0]);
    }
}

