/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.event.AltarCraftedEvent;
import WayofTime.bloodmagic.iface.IUpgradeTrainer;
import WayofTime.bloodmagic.item.ItemInscriptionTool;
import WayofTime.bloodmagic.item.types.ComponentTypes;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.ItemHelper;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="bloodmagic")
public class CraftingHandler {
    @SubscribeEvent
    public static void onAltarCrafted(AltarCraftedEvent event) {
        if (event.getOutput() == null) {
            return;
        }
        if (event.getOutput().func_77973_b() instanceof ItemInscriptionTool) {
            NBTHelper.checkNBT(event.getOutput());
            event.getOutput().func_77978_p().func_74768_a("uses", 10);
        }
        if (event.getOutput().func_77973_b() == ForgeModContainer.getInstance().universalBucket && event.getAltarRecipe().getSyphon() == 1000) {
            NBTTagCompound bucketTags = FluidUtil.getFilledBucket((FluidStack)new FluidStack(BlockLifeEssence.getLifeEssence(), 1000)).func_77978_p();
            event.getOutput().func_77982_d(bucketTags);
        }
    }

    @SubscribeEvent
    public static void onAnvil(AnvilUpdateEvent event) {
        LivingArmourUpgrade rightUpgrade;
        int rightLevel;
        int leftLevel;
        LivingArmourUpgrade leftUpgrade;
        if (event.getLeft().func_77973_b() == RegistrarBloodMagicItems.SIGIL_HOLDING) {
            if (event.getRight().func_77973_b() == Items.field_151057_cb) {
                ItemStack output = event.getLeft().func_77946_l();
                if (!output.func_77942_o()) {
                    output.func_77982_d(new NBTTagCompound());
                }
                output.func_77978_p().func_74778_a("color", event.getRight().func_82833_r());
                event.setCost(1);
                event.setOutput(output);
                return;
            }
            if (event.getRight().func_77973_b() == Items.field_151100_aR) {
                EnumDyeColor dyeColor = ItemBanner.func_179225_h((ItemStack)event.getRight());
                ItemStack output = event.getLeft().func_77946_l();
                if (!output.func_77942_o()) {
                    output.func_77982_d(new NBTTagCompound());
                }
                output.func_77978_p().func_74778_a("color", String.valueOf(Utils.DYE_COLOR_VALUES.getOrDefault(dyeColor, 0)));
                event.setCost(1);
                event.setOutput(output);
                return;
            }
        }
        if (event.getLeft().func_77973_b() == Items.field_151122_aG && event.getRight().func_77973_b() == Items.field_185160_cR && !event.getRight().func_77951_h()) {
            ItemStack output = new ItemStack(RegistrarBloodMagicItems.UPGRADE_TOME);
            output = NBTHelper.checkNBT(output);
            ItemHelper.LivingUpgrades.setKey(output, "bloodmagic.upgrade.elytra");
            ItemHelper.LivingUpgrades.setLevel(output, 1);
            event.setCost(30);
            event.setOutput(output);
            return;
        }
        if (event.getLeft().func_77973_b() == RegistrarBloodMagicItems.UPGRADE_TOME && event.getRight().func_77973_b() == RegistrarBloodMagicItems.UPGRADE_TOME && (leftUpgrade = ItemHelper.LivingUpgrades.getUpgrade(event.getLeft())) != null && !leftUpgrade.isDowngrade() && ItemHelper.LivingUpgrades.getKey(event.getLeft()).equals(ItemHelper.LivingUpgrades.getKey(event.getRight())) && (leftLevel = ItemHelper.LivingUpgrades.getLevel(event.getLeft())) == (rightLevel = ItemHelper.LivingUpgrades.getLevel(event.getRight())) && leftLevel < leftUpgrade.getMaxTier() - 1) {
            ItemStack outputStack = event.getLeft().func_77946_l();
            ItemHelper.LivingUpgrades.setLevel(outputStack, leftLevel + 1);
            event.setCost(leftLevel + 2);
            event.setOutput(outputStack);
            return;
        }
        if (event.getLeft().func_77973_b() instanceof IUpgradeTrainer && event.getRight().func_77973_b() == RegistrarBloodMagicItems.UPGRADE_TOME && (rightUpgrade = ItemHelper.LivingUpgrades.getUpgrade(event.getRight())) != null) {
            String key = ItemHelper.LivingUpgrades.getKey(event.getRight());
            ItemStack outputStack = event.getLeft().func_77946_l();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add(key);
            if (((IUpgradeTrainer)event.getLeft().func_77973_b()).setTrainedUpgrades(outputStack, keyList)) {
                event.setCost(1);
                event.setOutput(outputStack);
            }
        }
    }

    @SubscribeEvent
    public static void handleFuelLevel(FurnaceFuelBurnTimeEvent event) {
        if (ItemStack.func_179545_c((ItemStack)event.getItemStack(), (ItemStack)ComponentTypes.SAND_COAL.getStack())) {
            event.setBurnTime(TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151044_h)));
        }
    }
}

