/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.projectile;

import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.PlayerDemonWillHandler;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySentientArrow
extends EntityTippedArrow {
    public double reimbursedAmountOnHit = 0.0;
    public EnumDemonWillType type = EnumDemonWillType.DEFAULT;
    public int currentLevel = 0;
    public float[] destructiveExplosionRadius = new float[]{0.5f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f};
    public int[] poisonDuration = new int[]{50, 100, 150, 80, 120, 160, 200};
    public int[] poisonLevel = new int[]{0, 0, 0, 1, 1, 1, 1};
    public int[] levitationDuration = new int[]{20, 40, 60, 80, 100, 120, 160};
    public int[] levitationLevel = new int[]{0, 0, 0, 1, 1, 1, 2};
    public int[] slownessDuration = new int[]{40, 60, 100, 150, 200, 250, 300};
    public int[] slownessLevel = new int[]{0, 0, 0, 1, 1, 1, 2};

    public EntitySentientArrow(World worldIn) {
        super(worldIn);
    }

    public EntitySentientArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntitySentientArrow(World worldIn, EntityLivingBase shooter, EnumDemonWillType type, double reinburseAmount, int currentLevel) {
        super(worldIn, shooter);
        this.reimbursedAmountOnHit = reinburseAmount;
        this.type = type;
        this.currentLevel = currentLevel;
    }

    public void reimbursePlayer(EntityLivingBase hitEntity, float damage) {
        if (this.field_70250_c instanceof EntityPlayer) {
            if (hitEntity.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && !(hitEntity instanceof IMob)) {
                return;
            }
            PlayerDemonWillHandler.addDemonWill(this.type, (EntityPlayer)this.field_70250_c, this.reimbursedAmountOnHit * (double)damage / 20.0);
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        switch (this.type) {
            case CORROSIVE: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.currentLevel >= 0 ? this.poisonDuration[this.currentLevel] : 0, this.currentLevel >= 0 ? this.poisonLevel[this.currentLevel] : 0));
                break;
            }
            case DEFAULT: {
                break;
            }
            case DESTRUCTIVE: {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.currentLevel >= 0 ? this.destructiveExplosionRadius[this.currentLevel] : 0.0f, false);
                break;
            }
            case STEADFAST: {
                living.func_70690_d(new PotionEffect(MobEffects.field_188424_y, this.currentLevel >= 0 ? this.levitationDuration[this.currentLevel] : 0, this.currentLevel >= 0 ? this.levitationLevel[this.currentLevel] : 0));
                break;
            }
            case VENGEFUL: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.currentLevel >= 0 ? this.slownessDuration[this.currentLevel] : 0, this.currentLevel >= 0 ? this.slownessLevel[this.currentLevel] : 0));
                break;
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_184552_b > 0) {
            switch (this.type) {
                case DESTRUCTIVE: {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.currentLevel >= 0 ? this.destructiveExplosionRadius[this.currentLevel] : 0.0f, false);
                    this.func_70106_y();
                    break;
                }
                case CORROSIVE: {
                    break;
                }
                case DEFAULT: {
                    break;
                }
                case STEADFAST: {
                    break;
                }
                case VENGEFUL: {
                    break;
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74780_a("reimbursement", this.reimbursedAmountOnHit);
        tag.func_74768_a("currentLevel", this.currentLevel);
        tag.func_74778_a("demonWillType", this.type.toString());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.reimbursedAmountOnHit = tag.func_74769_h("reimbursement");
        this.type = EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
        this.currentLevel = tag.func_74762_e("currentLevel");
    }

    protected ItemStack func_184550_j() {
        return new ItemStack(Items.field_151032_g);
    }
}

