/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal;

import hellfirepvp.astralsorcery.common.data.research.EnumGatedKnowledge;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrystalProperties {
    private static final Random rand = new Random();
    public static final int MAX_SIZE_ROCK = 400;
    public static final int MAX_SIZE_CELESTIAL = 900;
    private static final CrystalProperties MAXED_ROCK_PROPERTIES = new CrystalProperties(400, 100, 100, 0, -1);
    private static final CrystalProperties MAXED_CELESTIAL_PROPERTIES = new CrystalProperties(900, 100, 100, 0, -1);
    protected int size;
    protected int purity;
    protected int collectiveCapability;
    protected int fractured = 0;
    protected int sizeOverride = -1;

    public CrystalProperties(int size, int purity, int collectiveCapability, int fractured, int sizeOverride) {
        this.size = size;
        this.purity = purity;
        this.collectiveCapability = collectiveCapability;
        this.fractured = fractured;
        this.sizeOverride = sizeOverride;
    }

    public int getSize() {
        return this.size;
    }

    public int getPurity() {
        return this.purity;
    }

    public int getCollectiveCapability() {
        return this.collectiveCapability;
    }

    public int getFracturation() {
        return this.fractured;
    }

    public int getSizeOverride() {
        return this.sizeOverride;
    }

    public static CrystalProperties readFromNBT(NBTTagCompound compound) {
        CrystalProperties prop = new CrystalProperties(0, 0, 0, 0, -1);
        prop.size = compound.func_74762_e("size");
        prop.purity = compound.func_74762_e("purity");
        prop.collectiveCapability = compound.func_74762_e("collect");
        prop.fractured = NBTHelper.getInteger(compound, "fract", 0);
        prop.sizeOverride = NBTHelper.getInteger(compound, "sizeOverride", -1);
        return prop;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("size", this.size);
        compound.func_74768_a("purity", this.purity);
        compound.func_74768_a("collect", this.collectiveCapability);
        compound.func_74768_a("fract", this.fractured);
        compound.func_74768_a("sizeOverride", this.sizeOverride);
    }

    public static CrystalProperties createStructural() {
        int size = Math.min(400, 200 + rand.nextInt(200));
        int purity = 60 + rand.nextInt(41);
        int collect = 45 + rand.nextInt(56);
        return new CrystalProperties(size, purity, collect, 0, -1);
    }

    public static CrystalProperties createRandomRock() {
        int size = Math.max(1, (rand.nextInt(400) + rand.nextInt(400)) / 2);
        int purity = (rand.nextInt(101) + rand.nextInt(101)) / 2;
        int collect = 5 + rand.nextInt(26);
        return new CrystalProperties(size, purity, collect, 0, -1);
    }

    public static CrystalProperties createRandomCelestial() {
        int size = Math.max(1, (rand.nextInt(900) + rand.nextInt(900)) / 2);
        int purity = 40 + rand.nextInt(61);
        int collect = 50 + rand.nextInt(26);
        return new CrystalProperties(size, purity, collect, 0, -1);
    }

    public static CrystalProperties getMaxRockProperties() {
        return MAXED_ROCK_PROPERTIES;
    }

    public static CrystalProperties getMaxCelestialProperties() {
        return MAXED_CELESTIAL_PROPERTIES;
    }

    public static int getMaxSize(ItemStack stack) {
        Block b;
        CrystalProperties prop = CrystalProperties.getCrystalProperties(stack);
        if (prop != null && prop.sizeOverride != -1) {
            return prop.sizeOverride;
        }
        if (stack.func_190926_b()) {
            return 400;
        }
        if (stack.func_77973_b() instanceof CrystalPropertyItem) {
            return ((CrystalPropertyItem)stack.func_77973_b()).getMaxSize(stack);
        }
        if (stack.func_77973_b() instanceof ItemBlock && (b = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof CrystalPropertyItem) {
            return ((CrystalPropertyItem)b).getMaxSize(stack);
        }
        return 400;
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Boolean> addPropertyTooltip(CrystalProperties prop, List<String> tooltip, int maxSize) {
        return CrystalProperties.addPropertyTooltip(prop, tooltip, GuiScreen.func_146272_n(), maxSize);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Boolean> addPropertyTooltip(CrystalProperties prop, List<String> tooltip, boolean extended, int maxSize) {
        return CrystalProperties.addPropertyTooltip(prop, tooltip, extended, ResearchManager.clientProgress.getTierReached(), maxSize);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Boolean> addPropertyTooltip(CrystalProperties prop, List<String> tooltip, boolean extended, ProgressionTier tier, int maxSize) {
        if (prop != null) {
            if (extended) {
                TextFormatting color;
                boolean missing = false;
                if (EnumGatedKnowledge.CRYSTAL_SIZE.canSee(tier)) {
                    color = prop.getSize() > maxSize ? TextFormatting.AQUA : (prop.getSize() == maxSize ? TextFormatting.GOLD : TextFormatting.BLUE);
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.size", (Object[])new Object[0]) + ": " + color + prop.getSize());
                } else {
                    missing = true;
                }
                if (EnumGatedKnowledge.CRYSTAL_PURITY.canSee(tier)) {
                    color = prop.getPurity() > 100 ? TextFormatting.AQUA : (prop.getPurity() == 100 ? TextFormatting.GOLD : TextFormatting.BLUE);
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.purity", (Object[])new Object[0]) + ": " + color + prop.getPurity() + "%");
                } else {
                    missing = true;
                }
                if (EnumGatedKnowledge.CRYSTAL_COLLECT.canSee(tier)) {
                    color = prop.getCollectiveCapability() > 100 ? TextFormatting.AQUA : (prop.getCollectiveCapability() == 100 ? TextFormatting.GOLD : TextFormatting.BLUE);
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.collectivity", (Object[])new Object[0]) + ": " + color + prop.getCollectiveCapability() + "%");
                } else {
                    missing = true;
                }
                if (EnumGatedKnowledge.CRYSTAL_FRACTURE.canSee(tier) && prop.getFracturation() > 0) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.fracture", (Object[])new Object[0]) + ": " + TextFormatting.RED + prop.getFracturation() + "%");
                }
                if (missing) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"progress.missing.knowledge", (Object[])new Object[0]));
                }
                return Optional.of(missing);
            }
            tooltip.add(TextFormatting.DARK_GRAY + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"misc.moreInformation", (Object[])new Object[0]));
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Nullable
    public CrystalProperties grindCopy(Random rand) {
        CrystalProperties copy = new CrystalProperties(this.size, this.purity, this.collectiveCapability, this.fractured, this.sizeOverride);
        int grind = 7 + rand.nextInt(5);
        double purity = (double)this.purity / 100.0;
        if (purity <= 0.4) {
            purity = 0.4;
        }
        for (int j = 0; j < 3; ++j) {
            if (!(purity <= (double)rand.nextFloat())) continue;
            grind += grind;
        }
        int collectToAdd = 3 + rand.nextInt(4);
        copy.size = this.size - grind;
        copy.collectiveCapability = Math.min(this.collectiveCapability > 100 ? this.collectiveCapability : 100, this.collectiveCapability + collectToAdd);
        if (copy.size <= 0) {
            return null;
        }
        return copy;
    }

    public static void applyCrystalProperties(ItemStack stack, CrystalProperties properties) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        NBTTagCompound crystalProp = new NBTTagCompound();
        crystalProp.func_74768_a("size", properties.getSize());
        crystalProp.func_74768_a("purity", properties.getPurity());
        crystalProp.func_74768_a("collectiveCapability", properties.getCollectiveCapability());
        crystalProp.func_74768_a("fract", properties.getFracturation());
        crystalProp.func_74768_a("sizeOverride", properties.getSizeOverride());
        cmp.func_74782_a("crystalProperties", (NBTBase)crystalProp);
    }

    @Nullable
    public static CrystalProperties getCrystalProperties(ItemStack stack) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        if (!cmp.func_74764_b("crystalProperties")) {
            return null;
        }
        NBTTagCompound prop = cmp.func_74775_l("crystalProperties");
        Integer size = prop.func_74762_e("size");
        Integer purity = prop.func_74762_e("purity");
        Integer colCap = prop.func_74762_e("collectiveCapability");
        Integer fract = prop.func_74762_e("fract");
        Integer sizeOvr = NBTHelper.getInteger(prop, "sizeOverride", -1);
        return new CrystalProperties(size, purity, colCap, fract, sizeOvr);
    }

    public String toString() {
        return "CrystalProperties={Size=" + this.size + ", Purity=" + this.purity + ",Cutting=" + this.collectiveCapability + ",Fractured=" + this.fractured + ",SizeOverride=" + this.sizeOverride + "}";
    }
}

