/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyVoidTrash
extends KeyPerk {
    private static final Random rand = new Random();
    private static String[] defaultDropList = new String[]{"minecraft:stone:0", "minecraft:dirt", "minecraft:cobblestone", "minecraft:gravel"};
    private static List<Predicate<ItemStack>> dropFilter = Lists.newArrayList();
    private static float chanceOre = 2.0E-4f;

    public KeyVoidTrash(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                dropFilter.clear();
                String[] drops = cfg.getStringList("DropList", this.getConfigurationSection(), defaultDropList, "The list of items to delete when dropped by a player with this perk. Damage/metadata value is optional and 'any' damage value is matched if omitted. Format: <modid>:<name>(:<metadata>)");
                chanceOre = cfg.getFloat("DropRareInstead", this.getConfigurationSection(), chanceOre, 0.0f, 1.0f, "Chance that a voided drop will instead yield a valuable random ore out of the 'perk_void_trash_replacement' configured ore table.");
                for (String s : drops) {
                    String[] split = s.split(":");
                    if (split.length == 3) {
                        int dmg;
                        try {
                            dmg = Integer.parseInt(split[2]);
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        ResourceLocation key = new ResourceLocation(split[0], split[1]);
                        dropFilter.add(i -> i.func_77973_b().getRegistryName().equals((Object)key) && i.func_77952_i() == dmg);
                        continue;
                    }
                    if (split.length != 2) continue;
                    ResourceLocation key = new ResourceLocation(s);
                    dropFilter.add(i -> i.func_77973_b().getRegistryName().equals((Object)key));
                }
            }
        });
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent ev) {
        World world = ev.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = ev.getHarvester();
        if (player == null) {
            return;
        }
        PlayerProgress prog = ResearchManager.getProgress(player, Side.SERVER);
        if (prog == null || !prog.hasPerkEffect(this)) {
            return;
        }
        float chance = PerkAttributeHelper.getOrCreateMap(player, Side.SERVER).modifyValue(player, prog, "astralsorcery.perkeffect", chanceOre);
        List drops = ev.getDrops();
        ArrayList addedDrops = Lists.newArrayList();
        Iterator iterator = drops.iterator();
        while (iterator.hasNext()) {
            ItemStack drop;
            ItemStack stack = (ItemStack)iterator.next();
            if (stack.func_190926_b() || !MiscUtils.matchesAny(stack, dropFilter)) continue;
            iterator.remove();
            if (!(rand.nextFloat() < chance) || (drop = OreTypes.PERK_VOID_TRASH_REPLACEMENT.getRandomOre(rand)).func_190926_b()) continue;
            addedDrops.add(ItemUtils.copyStackWithSize(drop, 1));
        }
        drops.addAll(addedDrops);
    }
}

