/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.flare;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.DataPatreonFlares;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PatreonFlareManager
implements ITickHandler {
    public static PatreonFlareManager INSTANCE = new PatreonFlareManager();

    private PatreonFlareManager() {
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        DataPatreonFlares dataFlares = (DataPatreonFlares)SyncDataHolder.getDataServer("PatreonFlares");
        for (Map.Entry<UUID, PatreonEffectHelper.PatreonEffect> effect : PatreonEffectHelper.getEntityPatrons(server.func_184103_al().func_181057_v()).entrySet()) {
            EntityPlayerMP owner = server.func_184103_al().func_177451_a(effect.getKey());
            PatreonPartialEntity entity = dataFlares.getEntity(Side.SERVER, effect.getKey());
            if (owner == null) {
                if (entity == null) continue;
                dataFlares.destroyEntity(entity);
                continue;
            }
            if (entity == null) {
                entity = dataFlares.createEntity((EntityPlayer)owner, effect.getValue());
            }
            World plWorld = owner.func_130014_f_();
            if (entity.getLastTickedDim() != null && plWorld.field_73011_w.getDimension() != entity.getLastTickedDim().intValue()) {
                entity.setPositionNear((EntityPlayer)owner);
            }
            if (!entity.update(plWorld)) continue;
            dataFlares.updateEntity(entity);
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Patreon Flare Manager (Server)";
    }
}

