/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EffectWorldInteraction
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectBlock {
    public EffectWorldInteraction(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    public EffectWorldInteraction(String name, int baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    public EffectWorldInteraction(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        AxisAlignedBB aabb = EffectWorldInteraction.getAABB(genome, housing);
        block0: for (int i = 0; i < 40; ++i) {
            for (int y = Math.max(0, MathHelper.func_76128_c((double)aabb.field_72338_b)); y <= Math.min(255, MathHelper.func_76143_f((double)aabb.field_72337_e)); ++y) {
                IBlockState state;
                int z;
                int x = EffectWorldInteraction.getRand(MathHelper.func_76128_c((double)aabb.field_72340_a), MathHelper.func_76143_f((double)aabb.field_72336_d), random);
                BlockPos blockPos = new BlockPos(x, y, z = EffectWorldInteraction.getRand(MathHelper.func_76128_c((double)aabb.field_72339_c), MathHelper.func_76143_f((double)aabb.field_72334_f), random));
                if (this.performPosEffect(world, blockPos, state = world.func_180495_p(blockPos), genome, housing)) break block0;
            }
        }
    }

    protected abstract boolean performPosEffect(World var1, BlockPos var2, IBlockState var3, IBeeGenome var4, IBeeHousing var5);

    @Override
    public boolean handleBlock(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing facing, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        IBlockState blockState = world.func_180495_p(pos);
        return this.performPosEffect(world, pos, blockState, genome, housing);
    }
}

