/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.skyworld;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.schema.SchemaRegistry;
import org.dave.compactmachines3.skyworld.SkyWorldConfiguration;

public class GuiSkyWorldConfiguration
extends GuiScreen {
    private final GuiCreateWorld parent;
    private SkyWorldConfiguration config;
    private GuiCheckBox lockedButton;
    private GuiButton closeButton;
    private SchemaScrollingList guiSchemaList;

    public GuiSkyWorldConfiguration(GuiCreateWorld parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.config = this.parent.field_146334_a != null && !this.parent.field_146334_a.trim().isEmpty() ? new SkyWorldConfiguration(this.parent.field_146334_a) : new SkyWorldConfiguration();
        int yOffset = 8;
        this.lockedButton = new GuiCheckBox(0, 8, yOffset, I18n.func_135052_a((String)"gui.compactmachines3.compactsky.configuration.startLocked", (Object[])new Object[0]), this.config.startLocked);
        this.field_146292_n.add(this.lockedButton);
        int listHeight = this.field_146295_m - 52 - (yOffset += 14);
        this.guiSchemaList = new SchemaScrollingList(this, 8, yOffset, 200, listHeight, 20);
        this.closeButton = new GuiButton(100, this.field_146294_l / 2 - 75, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.closeButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.config.startLocked = !this.config.startLocked;
        }
        this.parent.field_146334_a = this.config.getAsJsonString();
        if (button.field_146127_k == 100) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.guiSchemaList.drawScreen(mouseX, mouseY, partialTicks);
        Schema selectedSchema = this.guiSchemaList.getSelected();
        if (selectedSchema != null) {
            this.drawSchemaInfo(selectedSchema, mouseX, mouseY, partialTicks);
        }
    }

    private void drawSchemaInfo(Schema selectedSchema, int mouseX, int mouseY, float partialTicks) {
        String sizeLabel = I18n.func_135052_a((String)"gui.compactmachines3.compactsky.configuration.label.MachineSize", (Object[])new Object[0]);
        int dim = selectedSchema.getSize().getDimension() - 1;
        int yOffset = this.guiSchemaList.getY();
        String sizeString = String.format("%s: %s (%dx%dx%d)", sizeLabel, selectedSchema.getSize().func_176610_l(), dim, dim, dim);
        this.field_146289_q.func_175065_a(sizeString, 230.0f, (float)yOffset, -1, false);
        String descriptionLabel = I18n.func_135052_a((String)"gui.compactmachines3.compactsky.configuration.label.Description", (Object[])new Object[0]);
        String descriptionString = selectedSchema.getDescription().length() == 0 ? I18n.func_135052_a((String)"gui.compactmachines3.compactsky.configuration.warning.PleaseSpecifyADescription", (Object[])new Object[0]) : selectedSchema.getDescription();
        String descriptionStringFormatted = String.format("%s:\n%s", descriptionLabel, descriptionString);
        this.field_146289_q.func_78279_b(descriptionStringFormatted, 230, yOffset += 10, this.field_146294_l - 240, -1);
    }

    private static class SchemaScrollingList
    extends GuiScrollingList {
        int selected = -1;
        GuiSkyWorldConfiguration parent;
        List<Schema> schemaList;

        public SchemaScrollingList(GuiSkyWorldConfiguration parent, int x, int y, int listWidth, int listHeight, int entryHeight) {
            super(parent.field_146297_k, listWidth, listHeight, y, y + listHeight, x, entryHeight, parent.field_146294_l, parent.field_146295_m);
            this.parent = parent;
            this.schemaList = new ArrayList<Schema>(SchemaRegistry.instance.getSchemas());
            if (((GuiSkyWorldConfiguration)parent).config.schema != null) {
                this.selected = this.schemaList.indexOf(((GuiSkyWorldConfiguration)parent).config.schema);
            }
        }

        public int getY() {
            return this.top;
        }

        public Schema getSelected() {
            return this.schemaList.get(this.selected);
        }

        protected int getSize() {
            return this.schemaList.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            this.selected = index;
            ((GuiSkyWorldConfiguration)this.parent).config.schema = this.schemaList.get(this.selected);
            ((GuiSkyWorldConfiguration)this.parent).parent.field_146334_a = this.parent.config.getAsJsonString();
        }

        protected boolean isSelected(int index) {
            return index == this.selected;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            FontRenderer font = this.parent.field_146297_k.field_71466_p;
            font.func_78276_b(this.schemaList.get(slotIdx).getName(), this.left + 4, slotTop + 4, 0xFFFFFF);
        }
    }
}

