/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.machine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.dave.compactmachines3.gui.GUIHelper;
import org.dave.compactmachines3.gui.machine.GuiMachineContainer;
import org.dave.compactmachines3.gui.machine.GuiMachineData;
import org.dave.compactmachines3.gui.machine.GuiMachinePlayerWhitelist;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.init.Itemss;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.misc.RenderTickCounter;
import org.dave.compactmachines3.network.MessagePlayerWhiteListToggle;
import org.dave.compactmachines3.network.MessageRequestMachineAction;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.utility.ChunkUtils;
import org.dave.compactmachines3.utility.Logz;
import org.dave.compactmachines3.utility.ShrinkingDeviceUtils;
import org.lwjgl.input.Mouse;

public class GuiMachine
extends GuiContainer {
    protected ResourceLocation tabIcons;
    private int windowWidth = 200;
    private int windowHeight = 212;
    private int prevMouseX = -1;
    private int prevMouseY = -1;
    protected double rotateX = 0.0;
    protected double rotateY = -25.0;
    private GuiTextField guiWhiteListInput;
    private GuiMachinePlayerWhitelist guiWhiteList;
    private GuiButton guiWhiteListAddButton;
    private GuiCheckBox guiMachineLockedButton;
    private GuiButton guiEnterButton;
    int glListId = -1;
    int activeTab = 0;

    public GuiMachine() {
        super((Container)new GuiMachineContainer());
    }

    private boolean shouldShowTabs() {
        boolean isOwner = this.field_146297_k.field_71439_g.func_70005_c_().equals(GuiMachineData.owner);
        return isOwner;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabIcons = new ResourceLocation("compactmachines3", "textures/gui/tabicons.png");
        int offsetX = (int)((float)(this.field_146294_l - this.windowWidth) / 2.0f);
        int offsetY = (int)((float)(this.field_146295_m - this.windowHeight) / 2.0f);
        this.field_146292_n.clear();
        this.guiWhiteListAddButton = new GuiButton(0, offsetX + 5 + this.windowWidth - 30, offsetY + 44, 20, 20, "+");
        this.field_146292_n.add(this.guiWhiteListAddButton);
        this.guiMachineLockedButton = new GuiCheckBox(1, offsetX + 7, offsetY + 7, "", GuiMachineData.locked);
        this.field_146292_n.add(this.guiMachineLockedButton);
        this.guiWhiteListInput = new GuiTextField(0, this.field_146289_q, offsetX + 6, offsetY + 45, this.windowWidth - 33, 18);
        this.guiWhiteList = new GuiMachinePlayerWhitelist(this, offsetY + 65, offsetY + this.windowHeight - 5, offsetX + 5, 20, this.windowWidth - 10, this.windowHeight);
        this.guiEnterButton = new GuiButton(2, offsetX + 5 + this.windowWidth - 30, offsetY + this.windowHeight - 25, 20, 20, "");
        this.field_146292_n.add(this.guiEnterButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        List buttonListTemp = this.field_146292_n;
        this.field_146292_n = new ArrayList();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146292_n = buttonListTemp;
        if (!GuiMachineData.canRender) {
            return;
        }
        if (GuiMachineData.requiresNewDisplayList) {
            TileEntityRendererDispatcher.field_147556_a.func_147543_a((World)GuiMachineData.proxyWorld);
            if (this.glListId != -1) {
                GLAllocation.func_74523_b((int)this.glListId);
            }
            this.glListId = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glListId, (int)4864);
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            ArrayList<BlockPos> toRenderCopy = new ArrayList<BlockPos>(GuiMachineData.toRender);
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179118_c();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, toRenderCopy);
            GlStateManager.func_179141_d();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, toRenderCopy);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, toRenderCopy);
            GlStateManager.func_179103_j((int)7424);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, toRenderCopy);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_187415_K();
        }
        if (GuiMachineData.chunk != null && this.activeTab == 0) {
            this.renderChunk(partialTicks);
            this.drawOwner(partialTicks, mouseX, mouseY);
            this.drawEnterButton(partialTicks, mouseX, mouseY);
        }
        if (this.activeTab == 1) {
            this.drawWhitelist(partialTicks, mouseX, mouseY);
        }
    }

    private void drawEnterButton(float partialTicks, int mouseX, int mouseY) {
        if (!ShrinkingDeviceUtils.hasShrinkingDeviceInInventory((EntityPlayer)this.field_146297_k.field_71439_g)) {
            return;
        }
        if (GuiMachineData.coords == -1) {
            return;
        }
        if (!GuiMachineData.isAllowedToEnter((EntityPlayer)this.field_146297_k.field_71439_g)) {
            return;
        }
        this.guiEnterButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        ItemStack itemstack = new ItemStack((Item)Itemss.psd);
        GlStateManager.func_179123_a();
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(itemstack, this.guiEnterButton.field_146128_h + 2, this.guiEnterButton.field_146129_i + 1);
        RenderHelper.func_74519_b();
        GlStateManager.func_179099_b();
    }

    protected void drawOwner(float partialTicks, int mouseX, int mouseY) {
        float offsetX = (float)(this.field_146294_l - this.windowWidth) / 2.0f;
        float offsetY = (float)(this.field_146295_m - this.windowHeight) / 2.0f;
        if (GuiMachineData.owner != null) {
            this.field_146297_k.field_71466_p.func_175065_a(GuiMachineData.owner, offsetX + 8.0f, offsetY + (float)this.windowHeight - 16.0f, -14736343, false);
        } else {
            this.field_146297_k.field_71466_p.func_175065_a(I18n.func_135052_a((String)"tooltip.compactmachines3.machine.coords.unused", (Object[])new Object[0]), offsetX + 8.0f, offsetY + (float)this.windowHeight - 16.0f, -14736343, false);
        }
    }

    protected void drawWhitelist(float partialTicks, int mouseX, int mouseY) {
        this.guiWhiteListInput.func_146194_f();
        this.guiWhiteListAddButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.guiMachineLockedButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.guiWhiteList.drawScreen(mouseX, mouseY, partialTicks);
        int offsetX = (int)((float)(this.field_146294_l - this.windowWidth) / 2.0f);
        int offsetY = (int)((float)(this.field_146295_m - this.windowHeight) / 2.0f);
        this.field_146289_q.func_78276_b("Lock for other players", offsetX + 20, offsetY + 9, 2040873);
        this.field_146289_q.func_78276_b("Whitelist:", offsetX + 6, offsetY + 34, 2040873);
    }

    protected void drawTabs(float partialTicks, int mouseX, int mouseY) {
        if (!this.shouldShowTabs()) {
            return;
        }
        float offsetX = (float)(this.field_146294_l - this.windowWidth) / 2.0f;
        float offsetY = (float)(this.field_146295_m - this.windowHeight) / 2.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(offsetX - 28.0f), (float)(offsetY - 1.0f), (float)0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.tabIcons);
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        for (int index = 0; index < 2; ++index) {
            int xOffset = 0;
            int yOffset = index * 28;
            int buttonWidth = 32;
            if (this.activeTab != index) {
                buttonWidth = 28;
            }
            int textureY = index > 0 ? 56 : 28;
            this.func_73729_b(xOffset, yOffset + 0, this.activeTab == index ? 32 : 0, textureY, buttonWidth, 28);
        }
        this.func_73729_b(10, 36, 64, 0, 12, 11);
        ItemStack itemstack = new ItemStack((Block)Blockss.wall);
        GlStateManager.func_179123_a();
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(itemstack, 8, 6);
        RenderHelper.func_74519_b();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    protected void drawWindow(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.tabIcons);
        float offsetX = (float)(this.field_146294_l - this.windowWidth) / 2.0f;
        float offsetY = (float)(this.field_146295_m - this.windowHeight) / 2.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
        int texOffsetY = 12;
        int texOffsetX = 64;
        this.func_73729_b(0, 0, texOffsetX, texOffsetY, 4, 4);
        this.func_73729_b(this.windowWidth - 4, 0, texOffsetX + 4 + 64, texOffsetY, 4, 4);
        this.func_73729_b(0, this.windowHeight - 4, texOffsetX, texOffsetY + 4 + 64, 4, 4);
        this.func_73729_b(this.windowWidth - 4, this.windowHeight - 4, texOffsetX + 4 + 64, texOffsetY + 4 + 64, 4, 4);
        GUIHelper.drawStretchedTexture(4, 0, this.windowWidth - 8, 4, texOffsetX + 4, texOffsetY, 64, 4);
        GUIHelper.drawStretchedTexture(4, this.windowHeight - 4, this.windowWidth - 8, 4, texOffsetX + 4, texOffsetY + 4 + 64, 64, 4);
        GUIHelper.drawStretchedTexture(0, 4, 4, this.windowHeight - 8, texOffsetX, texOffsetY + 4, 4, 64);
        GUIHelper.drawStretchedTexture(this.windowWidth - 4, 4, 4, this.windowHeight - 8, texOffsetX + 64 + 4, texOffsetY + 3, 4, 64);
        GUIHelper.drawStretchedTexture(4, 4, this.windowWidth - 8, this.windowHeight - 8, texOffsetX + 4, texOffsetY + 4, 64, 64);
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawWindow(partialTicks, mouseX, mouseY);
        this.drawTabs(partialTicks, mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            String playerName = this.guiWhiteListInput.func_146179_b();
            if (playerName.length() == 0) {
                return;
            }
            PackageHandler.instance.sendToServer((IMessage)new MessagePlayerWhiteListToggle(GuiMachineData.coords, playerName));
            this.guiWhiteListInput.func_146180_a("");
        }
        if (button.field_146127_k == 1) {
            PackageHandler.instance.sendToServer((IMessage)new MessageRequestMachineAction(GuiMachineData.coords, MessageRequestMachineAction.Action.TOGGLE_LOCKED));
        }
        if (button.field_146127_k == 2) {
            PackageHandler.instance.sendToServer((IMessage)new MessageRequestMachineAction(GuiMachineData.coords, MessageRequestMachineAction.Action.TRY_TO_ENTER));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean typed = false;
        if (this.activeTab == 1) {
            typed = this.guiWhiteListInput.func_146201_a(typedChar, keyCode);
            if (keyCode == 28 || keyCode == 156) {
                this.guiWhiteListAddButton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(this.guiWhiteListAddButton);
            }
        }
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode) && !typed) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        List buttonListTemp = this.field_146292_n;
        this.field_146292_n = new ArrayList();
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.field_146292_n = buttonListTemp;
        this.guiWhiteListInput.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.activeTab == 1 && mouseButton == 0) {
            if (this.guiWhiteListAddButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                this.guiWhiteListAddButton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(this.guiWhiteListAddButton);
            }
            if (this.guiMachineLockedButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                this.guiMachineLockedButton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a((GuiButton)this.guiMachineLockedButton);
            }
        } else if (this.activeTab == 0 && mouseButton == 0) {
            boolean mousePressed = this.guiEnterButton.func_146116_c(this.field_146297_k, mouseX, mouseY);
            boolean hasDevice = ShrinkingDeviceUtils.hasShrinkingDeviceInInventory((EntityPlayer)this.field_146297_k.field_71439_g);
            boolean validCoords = GuiMachineData.coords != -1;
            boolean isAllowedToEnter = GuiMachineData.isAllowedToEnter((EntityPlayer)this.field_146297_k.field_71439_g);
            if (mousePressed && hasDevice && validCoords && isAllowedToEnter) {
                this.guiEnterButton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(this.guiEnterButton);
            }
        }
        if (this.shouldShowTabs()) {
            float offsetX = (float)(this.field_146294_l - this.windowWidth) / 2.0f - 28.0f;
            float offsetY = (float)(this.field_146295_m - this.windowHeight) / 2.0f;
            for (int tabIndex = 0; tabIndex < 2; ++tabIndex) {
                int tabY = (int)offsetY + tabIndex * 28;
                if ((float)mouseX < offsetX || (float)mouseX > offsetX + 28.0f || tabY >= mouseY || mouseY >= tabY + 28) continue;
                this.activeTab = tabIndex;
                if (tabIndex != 0) continue;
                this.rotateX = 0.0;
                mouseX = 0;
            }
        }
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
        if (this.rotateX == 0.0 && mouseX > 84) {
            this.rotateX = (float)RenderTickCounter.renderTicks * 45.0f / 128.0f;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.prevMouseX != mouseX || this.prevMouseY != mouseY) {
            int relativeX = mouseX - this.prevMouseX;
            int relativeY = mouseY - this.prevMouseY;
            this.rotateX += (double)relativeX;
            this.rotateY -= (double)relativeY;
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.activeTab == 1) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (this.guiWhiteList != null) {
                this.guiWhiteList.handleMouseInput(mouseX, mouseY);
            }
        }
    }

    public void renderChunk(float partialTicks) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179109_b((float)(this.field_146294_l / 2), (float)(this.field_146295_m / 2), (float)180.0f);
        double scaleToWindow = 1.0 / (double)GuiMachineData.machineSize;
        GlStateManager.func_179139_a((double)(scaleToWindow *= 8.0), (double)scaleToWindow, (double)scaleToWindow);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)this.rotateY), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)(this.rotateX == 0.0 ? (float)RenderTickCounter.renderTicks * 45.0f / 128.0f : (float)this.rotateX), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)-8.0f);
        float shift = (float)(GuiMachineData.machineSize - 1) * -4.0f;
        GlStateManager.func_179109_b((float)shift, (float)shift, (float)shift);
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        GlStateManager.func_179148_o((int)this.glListId);
        GlStateManager.func_179117_G();
        if (ConfigurationHandler.MachineSettings.renderTileEntitiesInGUI) {
            this.renderTileEntities(TileEntityRendererDispatcher.field_147556_a, new ArrayList<BlockPos>(GuiMachineData.toRender));
        }
        if (ConfigurationHandler.MachineSettings.renderLivingEntitiesInGUI) {
            this.renderEntities();
            GlStateManager.func_179147_l();
        }
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
        IBlockAccess blockAccess = ChunkUtils.getBlockAccessFromChunk(GuiMachineData.chunk);
        for (BlockPos pos : toRender) {
            IBlockState state = blockAccess.func_180495_p(pos);
            if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
            try {
                state = state.func_185899_b(blockAccess, pos);
            }
            catch (Exception e) {
                Logz.debug("Could not determine actual state of block: %s", state.func_177230_c());
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
            try {
                blockrendererdispatcher.func_175018_a(state, pos, blockAccess, buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    private void renderEntities() {
        ClassInheritanceMultiMap entities = GuiMachineData.chunk.func_177429_s()[2];
        for (Entity entity : entities) {
            GuiMachine.renderEntity(entity);
        }
    }

    private static void renderEntity(Entity entity) {
        GlStateManager.func_179094_E();
        double x = entity.field_70165_t % 1024.0;
        double y = entity.field_70163_u - 40.0;
        double z = entity.field_70161_v;
        RenderHelper.func_74519_b();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, x, y, z, entity.field_70177_z, 1.0f, false);
        }
        catch (Exception e) {
            Logz.debug("Could not render entity '%s': %s", entity.getClass().getSimpleName(), e.getMessage());
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    private void renderTileEntities(TileEntityRendererDispatcher renderer, List<BlockPos> toRender) {
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
        IBlockAccess blockAccess = ChunkUtils.getBlockAccessFromChunk(GuiMachineData.chunk);
        for (BlockPos pos : toRender) {
            TileEntity te = blockAccess.func_175625_s(pos);
            if (te == null) continue;
            te.func_145834_a((World)GuiMachineData.proxyWorld);
            te.func_174878_a(pos);
            if (te instanceof ITickable) {
                try {
                    ((ITickable)te).func_73660_a();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            renderer.field_147553_e = Minecraft.func_71410_x().field_71446_o;
            renderer.preDrawBatch();
            try {
                renderer.func_147549_a(te, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f);
            }
            catch (Exception e) {
                Logz.warn("Could not render tile entity '%s': %s", te.getClass().getSimpleName(), e.getMessage());
            }
            renderer.drawBatch(0);
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    public boolean func_73868_f() {
        return false;
    }
}

