/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.model.armor.ModelArmorTerrasteel;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public class ItemTerrasteelArmor
extends ItemManasteelArmor {
    private static ItemStack[] armorset;

    public ItemTerrasteelArmor(EntityEquipmentSlot type, String name) {
        super(type, name, BotaniaAPI.terrasteelArmorMaterial);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped provideArmorModelForSlot(ItemStack stack, EntityEquipmentSlot slot) {
        this.models.put(slot, new ModelArmorTerrasteel(slot));
        return (ModelBiped)this.models.get(slot);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EntityEquipmentSlot slot) {
        return ConfigHandler.enableArmorModels ? "botania:textures/model/armor_terrasteel.png" : (slot == EntityEquipmentSlot.CHEST ? "botania:textures/model/terrasteel_1.png" : "botania:textures/model/terrasteel_0.png");
    }

    @Override
    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 4 || super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
        if (slot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Terrasteel modifier " + this.type, (double)this.getArmorDisplay(null, new ItemStack((Item)this), this.type.func_188454_b()) / 20.0, 0));
        }
        return multimap;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        if (armorset == null) {
            armorset = new ItemStack[]{new ItemStack(ModItems.terrasteelHelm), new ItemStack(ModItems.terrasteelChest), new ItemStack(ModItems.terrasteelLegs), new ItemStack(ModItems.terrasteelBoots)};
        }
        return armorset;
    }

    @Override
    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.field_70460_b == null) {
            return false;
        }
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(3 - i);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ModItems.terrasteelHelm || stack.func_77973_b() == ModItems.terrasteelHelmRevealing;
            }
            case 1: {
                return stack.func_77973_b() == ModItems.terrasteelChest;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.terrasteelLegs;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.terrasteelBoots;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getArmorSetName() {
        return I18n.func_135052_a((String)"botania.armorset.terrasteel.name", (Object[])new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<String> list) {
        this.addStringToTooltip(I18n.func_135052_a((String)"botania.armorset.terrasteel.desc0", (Object[])new Object[0]), list);
        this.addStringToTooltip(I18n.func_135052_a((String)"botania.armorset.terrasteel.desc1", (Object[])new Object[0]), list);
        this.addStringToTooltip(I18n.func_135052_a((String)"botania.armorset.terrasteel.desc2", (Object[])new Object[0]), list);
    }
}

