/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerManager;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.Localization;

@SideOnly(value=Side.CLIENT)
public abstract class GuiManager
extends GuiBase {
    private TileEntityManager manager;

    public GuiManager(TileEntityManager manager, ContainerManager container) {
        super(container);
        this.manager = manager;
    }

    @Override
    public void drawGuiForeground(int x, int y) {
        int i;
        GlStateManager.func_179140_f();
        int[] coords = this.getMiddleCoords();
        this.getFontRenderer().func_78276_b(this.getManagerName(), coords[0] - 34, 65, 0x404040);
        this.getFontRenderer().func_78276_b(Localization.GUI.MANAGER.TITLE.translate(new String[0]), coords[0] + coords[2], 65, 0x404040);
        for (i = 0; i < 4; ++i) {
            coords = this.getTextCoords(i);
            String str = this.getMaxSizeText(i);
            this.getFontRenderer().func_78276_b(str, coords[0], coords[1], 0x404040);
        }
        for (i = 0; i < 4; ++i) {
            this.drawExtraOverlay(i, x, y);
            this.drawMouseOver(Localization.GUI.MANAGER.CHANGE_TRANSFER_DIRECTION.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.manager.toCart[i] ? Localization.GUI.MANAGER.DIRECTION_TO_CART.translate(new String[0]) : Localization.GUI.MANAGER.DIRECTION_FROM_CART.translate(new String[0])), x, y, this.getArrowCoords(i));
            this.drawMouseOver(Localization.GUI.MANAGER.CHANGE_TURN_BACK_SETTING.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.manager.color[i] == 5 ? Localization.GUI.MANAGER.TURN_BACK_NOT_SELECTED.translate(new String[0]) : (this.manager.doReturn[this.manager.color[i] - 1] ? Localization.GUI.MANAGER.TURN_BACK_DO.translate(new String[0]) : Localization.GUI.MANAGER.TURN_BACK_DO_NOT.translate(new String[0]))), x, y, this.getReturnCoords(i));
            this.drawMouseOver(Localization.GUI.MANAGER.CHANGE_TRANSFER_SIZE.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getMaxSizeOverlay(i), x, y, this.getTextCoords(i));
            this.drawMouseOver(Localization.GUI.MANAGER.CHANGE_SIDE.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SIDE.translate(new String[0]) + ": " + (new String[]{Localization.GUI.MANAGER.SIDE_RED.translate(new String[0]), Localization.GUI.MANAGER.SIDE_BLUE.translate(new String[0]), Localization.GUI.MANAGER.SIDE_YELLOW.translate(new String[0]), Localization.GUI.MANAGER.SIDE_GREEN.translate(new String[0]), Localization.GUI.MANAGER.SIDE_DISABLED.translate(new String[0])})[this.manager.color[i] - 1], x, y, this.getColorpickerCoords(i));
        }
        this.drawMouseOver(this.getLayoutString() + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getLayoutOption(this.manager.layoutType), x, y, this.getMiddleCoords());
        GlStateManager.func_179145_e();
    }

    protected void drawMouseOver(String str, int x, int y, int[] rect) {
        if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            this.drawMouseOver(str, x - this.getGuiLeft(), y - this.getGuiTop());
        }
    }

    @Override
    public void drawGuiBackground(float f, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.drawBackground(left, top);
        for (int i = 0; i < 4; ++i) {
            this.drawArrow(i, left, top);
            int color = this.manager.color[i] - 1;
            if (color == 4) continue;
            this.drawColors(i, color, left, top);
        }
        RenderItem renderitem = Minecraft.func_71410_x().func_175599_af();
        int[] coords = this.getMiddleCoords();
        RenderHelper.func_74520_c();
        renderitem.func_175042_a(new ItemStack(this.getBlock(), 1), left + coords[0], top + coords[1]);
        RenderHelper.func_74518_a();
        for (int j = 0; j < 4; ++j) {
            this.drawItems(j, renderitem, left, top);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawArrow(int id, int left, int top) {
        int sourceX = this.getArrowSourceX();
        int sourceY = 28;
        sourceY += 56 * id;
        if (!this.manager.toCart[id]) {
            sourceX += 28;
        }
        int targetX = this.getArrowCoords(id)[0];
        int targetY = this.getArrowCoords(id)[1];
        int sizeX = 28;
        int sizeY = 28;
        this.func_73729_b(left + targetX, top + targetY, sourceX, sourceY, sizeX, sizeY);
        if (id == this.manager.getLastSetting() && this.manager.color[id] != 5) {
            sourceY -= 28;
            int scaledProgress = this.manager.moveProgressScaled(42);
            int offsetX = 0;
            int offsetY = 0;
            if (this.manager.toCart[id]) {
                sizeX = 14;
                if (id % 2 == 0) {
                    offsetX = 14;
                }
                if ((sizeY = scaledProgress) > 19) {
                    sizeY = 19;
                }
                if (id < 2) {
                    offsetY = 28 - sizeY;
                }
            } else {
                sizeY = 14;
                if (id >= 2) {
                    offsetY = 14;
                }
                if ((sizeX = scaledProgress) > 19) {
                    sizeX = 19;
                }
                if (id % 2 == 1) {
                    offsetX = 28 - sizeX;
                }
            }
            this.func_73729_b(left + targetX + offsetX, top + targetY + offsetY, sourceX + offsetX, sourceY + offsetY, sizeX, sizeY);
            offsetX = 0;
            offsetY = 0;
            sizeX = 28;
            sizeY = 28;
            if (scaledProgress > 19) {
                scaledProgress -= 19;
                if (this.manager.toCart[id]) {
                    sizeX = scaledProgress;
                    if (sizeX > 23) {
                        sizeX = 23;
                    }
                    offsetX = id % 2 == 0 ? 22 - sizeX : 6;
                } else {
                    sizeY = scaledProgress;
                    if (sizeY > 23) {
                        sizeY = 23;
                    }
                    offsetY = id >= 2 ? 22 - sizeY : 6;
                }
                this.func_73729_b(left + targetX + offsetX, top + targetY + offsetY, sourceX + offsetX, sourceY + offsetY, sizeX, sizeY);
            }
        }
    }

    protected void drawColors(int id, int color, int left, int top) {
        int[] coords = this.getReturnCoords(id);
        this.func_73729_b(left + coords[0], top + coords[1], this.getColorSourceX() + (this.manager.doReturn[this.manager.color[id] - 1] ? 8 : 0), 80 + 8 * color, 8, 8);
        coords = this.getBoxCoords(id);
        this.func_73729_b(left + coords[0] - 2, top + coords[1] - 2, this.getColorSourceX(), 20 * color, 20, 20);
    }

    protected int[] getMiddleCoords() {
        return new int[]{this.getCenterTargetX() + 45, 61, 20, 20};
    }

    protected int[] getBoxCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 4 + x * 82;
        int yCoord = 17 + y * 88;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.manager.layoutType, x, y), 20, 20};
    }

    protected int[] getArrowCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 25 + x * 28;
        int yCoord = 17 + y * 76;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.manager.layoutType, x, y), 28, 28};
    }

    protected int[] getTextCoords(int id) {
        int[] coords = this.getBoxCoords(id);
        int xCoord = coords[0];
        int yCoord = coords[1];
        yCoord = id >= 2 ? (yCoord -= 12) : (yCoord += 20);
        return new int[]{xCoord, yCoord, 20, 10};
    }

    protected int[] getColorpickerCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 3 + x * 92;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.manager.layoutType, x, y), 8, 8};
    }

    protected int[] getReturnCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 14 + x * 70;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.manager.layoutType, x, y), 8, 8};
    }

    @Override
    public void mouseClick(int x, int y, int button) {
        super.mouseClick(x, y, button);
        if (button == 0 || button == 1) {
            if (this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.getMiddleCoords())) {
                this.manager.sendPacket(5, (byte)(button == 0 ? 1 : -1));
            } else {
                for (int i = 0; i < 4; ++i) {
                    byte data = (byte)i;
                    data = (byte)(data | (byte)(button << 2));
                    if (this.inRect(x, y, this.getArrowCoords(i))) {
                        this.manager.sendPacket(0, (byte)i);
                        break;
                    }
                    if (this.inRect(x, y, this.getTextCoords(i))) {
                        this.manager.sendPacket(2, data);
                        break;
                    }
                    if (this.inRect(x, y, this.getColorpickerCoords(i))) {
                        this.manager.sendPacket(3, data);
                        break;
                    }
                    if (this.inRect(x, y, this.getReturnCoords(i))) {
                        this.manager.sendPacket(4, (byte)i);
                        break;
                    }
                    if (this.sendOnClick(i, x, y, data)) break;
                }
            }
        }
    }

    protected void drawExtraOverlay(int id, int x, int y) {
    }

    protected boolean sendOnClick(int id, int x, int y, byte data) {
        return false;
    }

    protected int offsetObjectY(int layout, int x, int y) {
        return 0;
    }

    protected void drawItems(int id, RenderItem renderitem, int left, int top) {
    }

    protected abstract String getMaxSizeOverlay(int var1);

    protected abstract String getMaxSizeText(int var1);

    protected abstract void drawBackground(int var1, int var2);

    protected abstract int getArrowSourceX();

    protected abstract int getColorSourceX();

    protected abstract int getCenterTargetX();

    protected abstract Block getBlock();

    protected abstract String getManagerName();

    protected abstract String getLayoutOption(int var1);

    protected abstract String getLayoutString();

    protected TileEntityManager getManager() {
        return this.manager;
    }
}

