/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.init;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.IModInitializationHandler;
import it.zerono.mods.zerocore.lib.config.ConfigHandler;
import it.zerono.mods.zerocore.lib.init.IGameObject;
import it.zerono.mods.zerocore.lib.init.IGameObjectMapper;
import it.zerono.mods.zerocore.util.CodeHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class GameObjectsHandler
implements IModInitializationHandler {
    private final String _modId;
    private final ImmutableList<ConfigHandler> _configHandlers;
    private ImmutableMap<String, Block> _blocks;
    private ImmutableMap<String, Item> _items;
    private final List<IGameObjectMapper<Block>> _blocksMappers = Lists.newArrayList();
    private final List<IGameObjectMapper<Item>> _itemsMappers = Lists.newArrayList();

    protected GameObjectsHandler(ConfigHandler ... configs) {
        this._modId = CodeHelper.getModIdFromActiveModContainer();
        this._configHandlers = null != configs ? ImmutableList.copyOf((Object[])configs) : ImmutableList.of();
        this.addBlockRemapper(new LowerCaseMapper<Block>());
        this.addItemRemapper(new LowerCaseMapper<Item>());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.syncConfigHandlers();
    }

    protected void onRegisterBlocks(@Nonnull IForgeRegistry<Block> registry) {
    }

    protected void onRegisterTileEntities() {
    }

    protected void onRegisterItems(@Nonnull IForgeRegistry<Item> registry) {
    }

    protected void onRegisterOreDictionaryEntries() {
    }

    protected void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
    }

    protected void addBlockRemapper(@Nonnull IGameObjectMapper<Block> remapper) {
        this._blocksMappers.add(remapper);
    }

    protected void addItemRemapper(@Nonnull IGameObjectMapper<Item> remapper) {
        this._itemsMappers.add(remapper);
    }

    protected void registerTileEntity(@Nonnull String namePrefix, @Nonnull Class<? extends TileEntity> tileEntityClass) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)(namePrefix + tileEntityClass.getSimpleName()));
    }

    @SubscribeEvent
    protected void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        TrackingForgeRegistry<Block> tracker = new TrackingForgeRegistry<Block>(event.getRegistry());
        this.onRegisterBlocks(tracker);
        this._blocks = tracker.getTrackedObjects();
        this._blocksMappers.stream().forEach(mapper -> mapper.linkObjectsMap(this._blocks));
        this.onRegisterTileEntities();
    }

    @SubscribeEvent
    protected void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        TrackingForgeRegistry<Item> tracker = new TrackingForgeRegistry<Item>(registry);
        this.onRegisterItems(tracker);
        this._items = tracker.getTrackedObjects();
        GameObjectsHandler.raiseRegisterItemBlocks(this._blocks.values(), (IForgeRegistry<Item>)registry);
        this._itemsMappers.stream().forEach(mapper -> mapper.linkObjectsMap(this._items));
        this.onRegisterOreDictionaryEntries();
        GameObjectsHandler.raiseRegisterOreDictionaryEntries(this._blocks.values());
        GameObjectsHandler.raiseRegisterOreDictionaryEntries(this._items.values());
    }

    @SubscribeEvent
    protected void onRegisterRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        this.onRegisterRecipes((IForgeRegistry<IRecipe>)registry);
        GameObjectsHandler.raiseRegisterRecipes(this._blocks.values(), (IForgeRegistry<IRecipe>)registry);
        GameObjectsHandler.raiseRegisterRecipes(this._items.values(), (IForgeRegistry<IRecipe>)registry);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    protected void onRegisterModels(ModelRegistryEvent event) {
        GameObjectsHandler.raiseRegisterModels(this._blocks.values());
        GameObjectsHandler.raiseRegisterModels(this._items.values());
    }

    @SubscribeEvent
    protected void onMissinBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        GameObjectsHandler.remapObjects(this._blocksMappers, event.getMappings());
    }

    @SubscribeEvent
    protected void onMissingItemMapping(RegistryEvent.MissingMappings<Item> event) {
        GameObjectsHandler.remapObjects(this._itemsMappers, event.getMappings());
    }

    @SubscribeEvent
    protected void onConfigChangedFromGUI(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (this._modId.equalsIgnoreCase(event.getModID())) {
            this.syncConfigHandlers();
            this.notifyConfigListeners();
        }
    }

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        this.notifyConfigListeners();
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
    }

    private static <T extends IForgeRegistryEntry<T>> void raiseRegisterItemBlocks(@Nonnull ImmutableCollection<T> objects, @Nonnull IForgeRegistry<Item> registry) {
        for (IForgeRegistryEntry object : objects) {
            if (!(object instanceof IGameObject)) continue;
            ((IGameObject)object).onRegisterItemBlocks(registry);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void raiseRegisterOreDictionaryEntries(@Nonnull ImmutableCollection<T> objects) {
        for (IForgeRegistryEntry object : objects) {
            if (!(object instanceof IGameObject)) continue;
            ((IGameObject)object).onRegisterOreDictionaryEntries();
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void raiseRegisterRecipes(@Nonnull ImmutableCollection<T> objects, @Nonnull IForgeRegistry<IRecipe> registry) {
        for (IForgeRegistryEntry object : objects) {
            if (!(object instanceof IGameObject)) continue;
            ((IGameObject)object).onRegisterRecipes(registry);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static <T extends IForgeRegistryEntry<T>> void raiseRegisterModels(@Nonnull ImmutableCollection<T> objects) {
        for (IForgeRegistryEntry object : objects) {
            if (!(object instanceof IGameObject)) continue;
            ((IGameObject)object).onRegisterModels();
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void remapObjects(@Nonnull List<IGameObjectMapper<T>> mappers, @Nonnull ImmutableList<RegistryEvent.MissingMappings.Mapping<T>> mappings) {
        block0: for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            for (IGameObjectMapper<T> mapper : mappers) {
                mapper.remap(mapping);
                if (RegistryEvent.MissingMappings.Action.DEFAULT == mapping.getAction()) continue;
                continue block0;
            }
        }
    }

    private void syncConfigHandlers() {
        for (ConfigHandler handler : this._configHandlers) {
            handler.sync();
        }
    }

    private void notifyConfigListeners() {
        for (ConfigHandler handler : this._configHandlers) {
            handler.notifyListeners();
        }
    }

    private static class LowerCaseMapper<T extends IForgeRegistryEntry<T>>
    implements IGameObjectMapper<T> {
        private ImmutableMap<String, T> _map;

        private LowerCaseMapper() {
        }

        @Override
        public void linkObjectsMap(@Nonnull ImmutableMap<String, T> map) {
            this._map = map;
        }

        @Override
        public void remap(@Nonnull RegistryEvent.MissingMappings.Mapping<T> mapping) {
            String candidateName = mapping.key.func_110623_a().toLowerCase();
            if (this._map.containsKey((Object)candidateName)) {
                IForgeRegistryEntry replacement = (IForgeRegistryEntry)this._map.get((Object)candidateName);
                mapping.remap(replacement);
            }
        }
    }

    private static class TrackingForgeRegistry<T extends IForgeRegistryEntry<T>>
    implements IForgeRegistry<T> {
        private final IForgeRegistry<T> _registry;
        private final Map<String, T> _trackedObjects;

        public TrackingForgeRegistry(@Nonnull IForgeRegistry<T> registry) {
            this._registry = registry;
            this._trackedObjects = Maps.newHashMap();
        }

        @Nonnull
        public ImmutableMap<String, T> getTrackedObjects() {
            return ImmutableMap.copyOf(this._trackedObjects);
        }

        public Class<T> getRegistrySuperType() {
            return this._registry.getRegistrySuperType();
        }

        public void register(T value) {
            this._registry.register(value);
            this._trackedObjects.put(value.getRegistryName().func_110623_a(), value);
        }

        public void registerAll(T[] values) {
            for (T value : values) {
                this.register(value);
            }
        }

        public boolean containsKey(ResourceLocation key) {
            return this._registry.containsKey(key);
        }

        public boolean containsValue(T value) {
            return this._registry.containsValue(value);
        }

        @Nullable
        public T getValue(ResourceLocation key) {
            return (T)this._registry.getValue(key);
        }

        @Nullable
        public ResourceLocation getKey(T value) {
            return this._registry.getKey(value);
        }

        @Nonnull
        public Set<ResourceLocation> getKeys() {
            return this._registry.getKeys();
        }

        @Nonnull
        public List<T> getValues() {
            return this._registry.getValues();
        }

        @Nonnull
        public Set<Map.Entry<ResourceLocation, T>> getEntries() {
            return this._registry.getEntries();
        }

        public <T> T getSlaveMap(ResourceLocation slaveMapName, Class<T> type) {
            return (T)this._registry.getSlaveMap(slaveMapName, type);
        }

        public Iterator<T> iterator() {
            return this._registry.iterator();
        }
    }
}

