/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.OreIngredient;

public class RecipeUtils {
    private int j = 0;
    private String modID = "p455w0rdslib";
    private String modName = "p455w0rd's Library";
    public final List<IRecipe> RECIPES = new ArrayList<IRecipe>();

    public RecipeUtils() {
    }

    public RecipeUtils(String modID, String modName) {
        this.modID = modID;
        this.modName = modName;
    }

    public void addRecipe(int j, IRecipe rec) {
        if (rec.getRegistryName() == null) {
            this.RECIPES.add((IRecipe)rec.setRegistryName(new ResourceLocation(this.modID, "recipes" + j)));
        } else {
            this.RECIPES.add(rec);
        }
    }

    public void addRecipe(String name, IRecipe rec) {
        if (rec.getRegistryName() == null) {
            this.RECIPES.add((IRecipe)rec.setRegistryName(new ResourceLocation(this.modID, name)));
        } else {
            this.RECIPES.add(rec);
        }
    }

    @Deprecated
    public IRecipe addOldShaped(ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        ShapedRecipes recipe = new ShapedRecipes(new ResourceLocation(this.modID, output.func_77977_a()).toString(), primer.width, primer.height, primer.input, output);
        this.addRecipe(this.j++, (IRecipe)recipe);
        return recipe;
    }

    @Deprecated
    public void addOldShaped(String group, ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        this.addRecipe(this.j++, (IRecipe)new ShapedRecipes(new ResourceLocation(this.modID, group).toString(), primer.width, primer.height, primer.input, output));
    }

    @Deprecated
    public void addOldShaped(String name, String group, ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        this.addRecipe(this.j++, (IRecipe)new ShapedRecipes(new ResourceLocation(this.modID, group).toString(), primer.width, primer.height, primer.input, output).setRegistryName(this.modID, name));
    }

    @Deprecated
    public void addOldShapeless(ItemStack output, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)new ShapelessRecipes(new ResourceLocation(this.modID, "recipes" + this.j).toString(), output, this.createInput(input)));
    }

    @Deprecated
    public void addOldShapeless(String group, ItemStack output, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)new ShapelessRecipes(new ResourceLocation(this.modID, group).toString(), output, this.createInput(input)));
    }

    @Deprecated
    public void addOldShapeless(String name, String group, ItemStack output, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)new ShapelessRecipes(new ResourceLocation(this.modID, group).toString(), output, this.createInput(input)).setRegistryName(this.modID, name));
    }

    public void addShapeless(ItemStack output, Object ... inputs) {
        this.addRecipe(this.j++, (IRecipe)new ShapelessRecipes(this.modID + ":" + this.j, output, this.createInput(inputs)));
    }

    public void addShapeless(Item output, Object ... inputs) {
        this.addShapeless(new ItemStack(output), inputs);
    }

    public void addShapeless(Block output, Object ... inputs) {
        this.addShapeless(new ItemStack(output), inputs);
    }

    public void addSmallShapeless(ItemStack output, Ingredient input) {
        NonNullList k = NonNullList.func_191197_a((int)1, (Object)input);
        this.addRecipe(this.j++, (IRecipe)new ShapelessRecipes(this.modID + ":" + this.j, output, k));
    }

    public void addShapeless(String group, ItemStack output, Object ... inputs) {
        this.addRecipe(this.j++, (IRecipe)new ShapelessRecipes(this.modID + ":" + group, output, this.createInput(inputs)));
    }

    public void addShapeless(String group, Item output, Object ... inputs) {
        this.addShapeless(group, new ItemStack(output), inputs);
    }

    public void addShapeless(String group, Block output, Object ... inputs) {
        this.addShapeless(group, new ItemStack(output), inputs);
    }

    public void addShaped(ItemStack output, int width, int height, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)this.genShaped(output, width, height, input));
    }

    public void addShaped(Item output, int width, int height, Object ... input) {
        this.addShaped(new ItemStack(output), width, height, input);
    }

    public void addShaped(Block output, int width, int height, Object ... input) {
        this.addShaped(new ItemStack(output), width, height, input);
    }

    public void addShaped(String group, ItemStack output, int width, int height, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)this.genShaped(this.modID + ":" + group, output, width, height, input));
    }

    public void addShaped(String group, Item output, int width, int height, Object ... input) {
        this.addShaped(group, new ItemStack(output), width, height, input);
    }

    public void addShaped(String group, Block output, int width, int height, Object ... input) {
        this.addShaped(group, new ItemStack(output), width, height, input);
    }

    public ShapedRecipes genShaped(ItemStack output, int l, int w, Object[] input) {
        if (input[0] instanceof Object[]) {
            input = (Object[])input[0];
        }
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of " + this.modName);
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)new OreIngredient((String)k));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof Item) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)k)}));
                continue;
            }
            if (k instanceof Block) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)k)}));
                continue;
            }
            inputL.add(i, (Object)Ingredient.field_193370_a);
        }
        return new ShapedRecipes(this.modID + ":" + this.j, l, w, inputL, output);
    }

    public ShapedRecipes genShaped(String group, ItemStack output, int l, int w, Object[] input) {
        if (input[0] instanceof List) {
            input = ((List)input[0]).toArray();
        } else if (input[0] instanceof Object[]) {
            input = (Object[])input[0];
        }
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of " + this.modName);
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)new OreIngredient((String)k));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof Item) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)k)}));
                continue;
            }
            if (k instanceof Block) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)k)}));
                continue;
            }
            inputL.add(i, (Object)Ingredient.field_193370_a);
        }
        return new ShapedRecipes(group, l, w, inputL, output);
    }

    public NonNullList<Ingredient> createInput(Object[] input) {
        if (input[0] instanceof List) {
            input = ((List)input[0]).toArray();
        } else if (input[0] instanceof Object[]) {
            input = (Object[])input[0];
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)new OreIngredient((String)k));
                continue;
            }
            if (k instanceof ItemStack) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof Item) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)k)}));
                continue;
            }
            if (k instanceof Block) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)k)}));
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid shapeless recipe.  Complain to the author of " + this.modName);
        }
        return inputL;
    }
}

