/*
 * Decompiled with CFR 0.152.
 */
package mcjty.nice.blocks;

import java.util.ArrayList;
import java.util.List;
import mcjty.nice.blocks.GenericBlock;
import mcjty.nice.blocks.GenericParticleTileEntity;
import mcjty.nice.client.BlockColor;
import mcjty.nice.particle.ParticleType;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GenericParticleBlock
extends GenericBlock {
    public static final PropertyEnum<BlockColor> COLOR = PropertyEnum.func_177709_a((String)"color", BlockColor.class);

    public GenericParticleBlock(String name) {
        super(name, Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.getState());
    }

    protected IBlockState getState() {
        return this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)((Object)BlockColor.BLUE));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.BLUE + "Select with item to change");
        tooltip.add(TextFormatting.BLUE + "(the item is not consumed)");
        tooltip.add("    Diamond for sparkles");
        tooltip.add("    Water bucket for bubbles");
        tooltip.add("    Wool for smoke");
        tooltip.add("    Fish for fish");
        if (stack.func_77942_o()) {
            int color = stack.func_77978_p().func_74762_e("color");
            tooltip.add(TextFormatting.YELLOW + "Block color: " + BlockColor.values()[color].func_176610_l());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericParticleTileEntity) {
            GenericParticleTileEntity cylinder = (GenericParticleTileEntity)te;
            if (Items.field_151045_i.equals(heldItem.func_77973_b())) {
                cylinder.setType(ParticleType.BLINK);
                return true;
            }
            if (Items.field_151115_aP.equals(heldItem.func_77973_b())) {
                cylinder.setType(ParticleType.FISH);
                return true;
            }
            if (Item.func_150898_a((Block)Blocks.field_150325_L).equals(heldItem.func_77973_b())) {
                cylinder.setType(ParticleType.SMOKE);
                return true;
            }
            if (Items.field_151131_as.equals(heldItem.func_77973_b())) {
                cylinder.setType(ParticleType.BUBBLE);
                return true;
            }
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof GenericParticleTileEntity) {
            int col = 0;
            if (stack.func_77942_o()) {
                col = stack.func_77978_p().func_74762_e("color");
            }
            ((GenericParticleTileEntity)te).setColor(BlockColor.values()[col]);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericParticleTileEntity) {
            BlockColor color = ((GenericParticleTileEntity)te).getColor();
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("color", color.ordinal());
            stack.func_77982_d(tagCompound);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        BlockColor color = BlockColor.BLUE;
        if (te instanceof GenericParticleTileEntity) {
            color = ((GenericParticleTileEntity)te).getColor();
        }
        return state.func_177226_a(COLOR, (Comparable)((Object)color));
    }

    public static ItemStack makeColoredBlock(Block block, BlockColor color, int amount) {
        ItemStack i = new ItemStack(block, amount);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("color", color.ordinal());
        i.func_77982_d(nbt);
        return i;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }
}

