/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.event;

import java.lang.reflect.Constructor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import openmods.OpenMods;
import openmods.network.event.EventDirection;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventDispatcher;
import openmods.network.event.NetworkEventEntry;
import openmods.network.event.NetworkEventMeta;
import openmods.utils.CommonRegistryCallbacks;
import openmods.utils.RegistrationContextBase;

@Mod.EventBusSubscriber
public class NetworkEventManager {
    private static NetworkEventDispatcher DISPATCHER;

    public static NetworkEventDispatcher dispatcher() {
        return DISPATCHER;
    }

    @SubscribeEvent
    public static void registerRegistry(RegistryEvent.NewRegistry e) {
        IForgeRegistry registry = new RegistryBuilder().setName(OpenMods.location("network_events")).setType(NetworkEventEntry.class).setIDRange(0, 65535).addCallback((Object)new Callbacks()).disableSaving().create();
        DISPATCHER = new NetworkEventDispatcher((IForgeRegistry<NetworkEventEntry>)registry);
    }

    public static RegistrationContext startRegistration(IForgeRegistry<NetworkEventEntry> registry) {
        return new RegistrationContext(registry);
    }

    public static RegistrationContext startRegistration(IForgeRegistry<NetworkEventEntry> registry, String domain) {
        return new RegistrationContext(registry, domain);
    }

    public static class RegistrationContext
    extends RegistrationContextBase<NetworkEventEntry> {
        public RegistrationContext(IForgeRegistry<NetworkEventEntry> registry, String domain) {
            super(registry, domain);
        }

        public RegistrationContext(IForgeRegistry<NetworkEventEntry> registry) {
            super(registry);
        }

        public RegistrationContext register(final Class<? extends NetworkEvent> cls) {
            Constructor<? extends NetworkEvent> ctor;
            NetworkEventMeta meta = cls.getAnnotation(NetworkEventMeta.class);
            final EventDirection direction = meta != null ? meta.direction() : EventDirection.ANY;
            try {
                ctor = cls.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class " + cls + " has no parameterless constructor");
            }
            ResourceLocation eventId = new ResourceLocation(this.domain, cls.getName());
            this.registry.register((IForgeRegistryEntry)new NetworkEventEntry(){

                @Override
                public EventDirection getDirection() {
                    return direction;
                }

                @Override
                public NetworkEvent createPacket() {
                    try {
                        return (NetworkEvent)((Object)ctor.newInstance(new Object[0]));
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Class<? extends NetworkEvent> getPacketType() {
                    return cls;
                }

                public String toString() {
                    return "Wrapper{" + cls + "}";
                }
            }.setRegistryName(eventId));
            return this;
        }
    }

    private static class Callbacks
    extends CommonRegistryCallbacks<Class<? extends NetworkEvent>, NetworkEventEntry> {
        private Callbacks() {
        }

        @Override
        protected Class<? extends NetworkEvent> getWrappedObject(NetworkEventEntry entry) {
            return entry.getPacketType();
        }
    }
}

