/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation;

import cofh.core.init.CoreEnchantments;
import cofh.core.init.CorePotions;
import cofh.core.init.CoreProps;
import cofh.core.util.ConfigHandler;
import cofh.thermalfoundation.gui.GuiHandler;
import cofh.thermalfoundation.init.TFBlocks;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.init.TFItems;
import cofh.thermalfoundation.init.TFPlugins;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.init.TFSounds;
import cofh.thermalfoundation.network.PacketTFBase;
import cofh.thermalfoundation.proxy.Proxy;
import cofh.thermalfoundation.util.IMCHandler;
import cofh.thermalfoundation.util.LexiconManager;
import java.io.File;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="thermalfoundation", name="Thermal Foundation", version="2.5.0", dependencies="required-after:cofhcore@[4.5.0,4.6.0);required-after:cofhworld@[1.2.0,2.0.0);before:enderio;before:immersiveengineering", updateJSON="https://raw.github.com/cofh/version/master/thermalfoundation_update.json", certificateFingerprint="8a6abf2cb9e141b866580d369ba6548732eff25f", acceptedMinecraftVersions="[1.12.2]")
public class ThermalFoundation {
    public static final String MOD_ID = "thermalfoundation";
    public static final String MOD_NAME = "Thermal Foundation";
    public static final String VERSION = "2.5.0";
    public static final String VERSION_MAX = "2.6.0";
    public static final String VERSION_GROUP = "required-after:thermalfoundation@[2.5.0,2.6.0);";
    public static final String UPDATE_URL = "https://raw.github.com/cofh/version/master/thermalfoundation_update.json";
    public static final String DEPENDENCIES = "required-after:cofhcore@[4.5.0,4.6.0);required-after:cofhworld@[1.2.0,2.0.0);before:enderio;before:immersiveengineering";
    public static final String MOD_GUI_FACTORY = "cofh.thermalfoundation.gui.GuiConfigTFFactory";
    @Mod.Instance(value="thermalfoundation")
    public static ThermalFoundation instance;
    @SidedProxy(clientSide="cofh.thermalfoundation.proxy.ProxyClient", serverSide="cofh.thermalfoundation.proxy.Proxy")
    public static Proxy proxy;
    public static final Logger LOG;
    public static final ConfigHandler CONFIG;
    public static final ConfigHandler CONFIG_CLIENT;
    public static final GuiHandler GUI_HANDLER;
    public static CreativeTabs tabCommon;
    public static CreativeTabs tabItems;
    public static CreativeTabs tabUtils;
    public static CreativeTabs tabTools;
    public static CreativeTabs tabMisc;
    public static CreativeTabs tabBasicTools;
    public static CreativeTabs tabBasicCombat;
    public static CreativeTabs tabBasicArmor;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CONFIG.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/thermalfoundation/common.cfg"), true));
        CONFIG_CLIENT.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/thermalfoundation/client.cfg"), true));
        TFProps.preInit();
        TFBlocks.preInit();
        TFItems.preInit();
        TFEquipment.preInit();
        TFFluids.preInit();
        TFSounds.preInit();
        TFPlugins.preInit();
        CoreEnchantments.register();
        CorePotions.register();
        this.registerHandlers();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        proxy.initialize(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        IMCHandler.INSTANCE.handleIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)this));
        LexiconManager.loadComplete();
        CONFIG.cleanUp(false, true);
        CONFIG_CLIENT.cleanUp(false, true);
        LOG.info("Thermal Foundation: Load Complete.");
    }

    @Mod.EventHandler
    public void handleIdMappingEvent(FMLModIdMappingEvent event) {
        TFFluids.refreshReferences();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        TFPlugins.initialize();
        IMCHandler.INSTANCE.handleIMC((List<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    private void registerHandlers() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)GUI_HANDLER);
        LexiconManager.initialize();
        PacketTFBase.initialize();
    }

    static {
        LOG = LogManager.getLogger((String)MOD_ID);
        CONFIG = new ConfigHandler(VERSION);
        CONFIG_CLIENT = new ConfigHandler(VERSION);
        GUI_HANDLER = new GuiHandler();
        FluidRegistry.enableUniversalBucket();
    }
}

