/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common;

import com.google.common.collect.ImmutableList;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.command.ICommand;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ITwoNamedPage;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.common.advancements.AlfPortalTrigger;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.advancements.DopplegangerNoArmorTrigger;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.block.ModBanners;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModMultiblocks;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.command.CommandOpen;
import vazkii.botania.common.core.command.CommandShare;
import vazkii.botania.common.core.command.CommandSkyblockSpread;
import vazkii.botania.common.core.handler.BiomeDecorationHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.IMCHandler;
import vazkii.botania.common.core.handler.InternalMethodHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.loot.LootHandler;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.crafting.ModBrewRecipes;
import vazkii.botania.common.crafting.ModCraftingRecipes;
import vazkii.botania.common.crafting.ModElvenTradeRecipes;
import vazkii.botania.common.crafting.ModManaAlchemyRecipes;
import vazkii.botania.common.crafting.ModManaConjurationRecipes;
import vazkii.botania.common.crafting.ModManaInfusionRecipes;
import vazkii.botania.common.crafting.ModPetalRecipes;
import vazkii.botania.common.crafting.ModPureDaisyRecipes;
import vazkii.botania.common.crafting.ModRuneRecipes;
import vazkii.botania.common.entity.EntityCorporeaSpark;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.EntityFlameRing;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.entity.EntityMagicMissile;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.entity.EntityPinkWither;
import vazkii.botania.common.entity.EntitySignalFlare;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.integration.thaumcraft.TCAspects;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.network.GuiHandler;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.common.world.WorldTypeSkyblock;

@Mod(modid="botania", name="Botania", version="r1.10-355", dependencies="required-after:baubles@[1.5.2,);after:thaumcraft@[6.1.BETA21,);after:jei@[1.12.2-4.10.0.198,)", guiFactory="vazkii.botania.client.core.proxy.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Botania {
    public static boolean gardenOfGlassLoaded = false;
    public static boolean thaumcraftLoaded = false;
    public static boolean bcTriggersLoaded = false;
    public static boolean bloodMagicLoaded = false;
    public static boolean coloredLightsLoaded = false;
    public static boolean etFuturumLoaded = false;
    @Mod.Instance(value="botania")
    public static Botania instance;
    @SidedProxy(serverSide="vazkii.botania.common.core.proxy.ServerProxy", clientSide="vazkii.botania.client.core.proxy.ClientProxy")
    public static IProxy proxy;
    public static final Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        gardenOfGlassLoaded = Loader.isModLoaded((String)"gardenofglass");
        thaumcraftLoaded = Loader.isModLoaded((String)"thaumcraft");
        bcTriggersLoaded = ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|statements");
        bloodMagicLoaded = Loader.isModLoaded((String)"bloodmagic");
        coloredLightsLoaded = Loader.isModLoaded((String)"easycoloredlights");
        etFuturumLoaded = Loader.isModLoaded((String)"etfuturum");
        BotaniaAPI.internalHandler = new InternalMethodHandler();
        ConfigHandler.loadConfig(event.getSuggestedConfigurationFile());
        PacketHandler.init();
        ModEntities.init();
        ModBrews.init();
        ModMultiblocks.init();
        if (gardenOfGlassLoaded) {
            new WorldTypeSkyblock();
        }
        CriteriaTriggers.func_192118_a((ICriterionTrigger)AlfPortalTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)CorporeaRequestTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)DopplegangerNoArmorTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)RelicBindTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)UseItemSuccessTrigger.INSTANCE);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModBanners.init();
        ModPetalRecipes.init();
        ModPureDaisyRecipes.init();
        ModRuneRecipes.init();
        ModManaAlchemyRecipes.init();
        ModManaConjurationRecipes.init();
        ModManaInfusionRecipes.init();
        ModElvenTradeRecipes.init();
        ModBrewRecipes.init();
        ModCraftingRecipes.init();
        LexiconData.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.TERRAIN_GEN_BUS.register(BiomeDecorationHandler.class);
        MinecraftForge.EVENT_BUS.register((Object)ManaNetworkHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)TileCorporeaIndex.getInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        if (gardenOfGlassLoaded) {
            MinecraftForge.EVENT_BUS.register(SkyblockWorldEvents.class);
        }
        FMLInterModComms.sendMessage((String)"projecte", (String)"interdictionblacklist", (String)EntityManaBurst.class.getCanonicalName());
        if (thaumcraftLoaded && ConfigHandler.enableThaumcraftAspects) {
            MinecraftForge.EVENT_BUS.register(TCAspects.class);
        }
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (thaumcraftLoaded) {
            ModBrews.initTC();
            ModBrewRecipes.initTC();
            try {
                Class<?> clazz = Class.forName("thaumcraft.common.entities.EntityFluxRift");
                BotaniaAPI.blacklistEntityFromGravityRod(clazz);
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
        }
        ModBlocks.addDispenserBehaviours();
        ConfigHandler.loadPostInit();
        LexiconData.postInit();
        int words = 0;
        for (LexiconEntry entry : BotaniaAPI.getAllEntries()) {
            for (LexiconPage page : entry.pages) {
                words += this.countWords(page.getUnlocalizedName());
                if (!(page instanceof ITwoNamedPage)) continue;
                words += this.countWords(((ITwoNamedPage)((Object)page)).getSecondUnlocalizedName());
            }
        }
        LOGGER.info("The Lexica Botania has {} words.", (Object)words);
        this.registerDefaultEntityBlacklist();
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerAboutToStartEvent event) {
        String expect;
        String clname = BotaniaAPI.internalHandler.getClass().getName();
        if (!clname.equals(expect = "vazkii.botania.common.core.handler.InternalMethodHandler")) {
            new IllegalAccessError("The Botania API internal method handler has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Expected classname: " + expect + ", Actual classname: " + clname + ")").printStackTrace();
            FMLCommonHandler.instance().exitJava(1, true);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandShare());
        event.registerServerCommand((ICommand)new CommandOpen());
        if (gardenOfGlassLoaded) {
            event.registerServerCommand((ICommand)new CommandSkyblockSpread());
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        ManaNetworkHandler.instance.clear();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        IMCHandler.processMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    private int countWords(String s) {
        String s1 = I18n.func_74838_a((String)s);
        return s1.split("\\s+").length;
    }

    private void registerDefaultEntityBlacklist() {
        BotaniaAPI.blacklistEntityFromGravityRod(EntityDragon.class);
        BotaniaAPI.blacklistEntityFromGravityRod(MultiPartEntityPart.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityWither.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityItemFrame.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityEnderCrystal.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityPainting.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityCorporeaSpark.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityDoppleganger.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityFlameRing.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityMagicLandmine.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityMagicMissile.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityManaBurst.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntityPinkWither.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntitySignalFlare.class);
        BotaniaAPI.blacklistEntityFromGravityRod(EntitySpark.class);
        BotaniaAPI.blacklistEntityFromGravityRod(TileLightRelay.EntityPlayerMover.class);
    }

    static {
        LOGGER = LogManager.getLogger((String)"botania");
    }
}

