/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.manapool;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.integration.jei.manapool.ManaPoolRecipeWrapper;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ManaPoolRecipeCategory
implements IRecipeCategory {
    public static final String UID = "botania.manaPool";
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final ItemStack renderStack = new ItemStack(ModBlocks.pool);

    public ManaPoolRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 64);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.manaPool", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/pureDaisyOverlay.png"), 0, 0, 64, 46);
        ItemNBTHelper.setBoolean(this.renderStack, "RenderFull", true);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.overlay.draw(minecraft, 48, 0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        if (!(recipeWrapper instanceof ManaPoolRecipeWrapper)) {
            return;
        }
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 40, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(ItemStack.class).get(0));
        ++index;
        if (ingredients.getInputs(ItemStack.class).size() > 1) {
            recipeLayout.getItemStacks().init(index, true, 20, 12);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(ItemStack.class).get(1));
            ++index;
        }
        recipeLayout.getItemStacks().init(index, true, 70, 12);
        recipeLayout.getItemStacks().set(index, this.renderStack);
        recipeLayout.getItemStacks().init(++index, false, 99, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(ItemStack.class).get(0));
    }

    public List getTooltipStrings(int mouseX, int mouseY) {
        return new ArrayList();
    }

    @Nonnull
    public String getModName() {
        return "Botania";
    }
}

