/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.AbstractCoroutine;
import kotlinx.coroutines.experimental.BlockingEventLoop;
import kotlinx.coroutines.experimental.CompletedExceptionally;
import kotlinx.coroutines.experimental.EventLoop;
import kotlinx.coroutines.experimental.TimeSourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0010\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkotlinx/coroutines/experimental/BlockingCoroutine;", "T", "Lkotlinx/coroutines/experimental/AbstractCoroutine;", "parentContext", "Lkotlin/coroutines/experimental/CoroutineContext;", "blockedThread", "Ljava/lang/Thread;", "eventLoop", "Lkotlinx/coroutines/experimental/EventLoop;", "privateEventLoop", "", "(Lkotlin/coroutines/experimental/CoroutineContext;Ljava/lang/Thread;Lkotlinx/coroutines/experimental/EventLoop;Z)V", "joinBlocking", "()Ljava/lang/Object;", "onCancellationInternal", "", "exceptionally", "Lkotlinx/coroutines/experimental/CompletedExceptionally;", "onCancellationInternal$kotlinx_coroutines_core", "kotlinx-coroutines-core"})
final class BlockingCoroutine<T>
extends AbstractCoroutine<T> {
    private final Thread blockedThread;
    private final EventLoop eventLoop;
    private final boolean privateEventLoop;

    @Override
    public void onCancellationInternal$kotlinx_coroutines_core(@Nullable CompletedExceptionally exceptionally) {
        if (Intrinsics.areEqual(Thread.currentThread(), this.blockedThread) ^ true) {
            LockSupport.unpark(this.blockedThread);
        }
    }

    public final T joinBlocking() {
        TimeSourceKt.getTimeSource().registerTimeLoopThread();
        while (true) {
            long parkNanos;
            if (Thread.interrupted()) {
                InterruptedException interruptedException;
                InterruptedException it = interruptedException = new InterruptedException();
                this.cancel(it);
                throw (Throwable)interruptedException;
            }
            EventLoop eventLoop = this.eventLoop;
            long l = parkNanos = eventLoop != null ? eventLoop.processNextEvent() : Long.MAX_VALUE;
            if (this.isCompleted()) break;
            TimeSourceKt.getTimeSource().parkNanos(this, parkNanos);
        }
        if (this.privateEventLoop) {
            BlockingEventLoop parkNanos;
            EventLoop eventLoop = this.eventLoop;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.experimental.BlockingEventLoop");
            }
            BlockingEventLoop $receiver = parkNanos = (BlockingEventLoop)eventLoop;
            $receiver.setCompleted(true);
            $receiver.shutdown();
        }
        TimeSourceKt.getTimeSource().unregisterTimeLoopThread();
        Object state = this.getState$kotlinx_coroutines_core();
        Object object = state;
        if (!(object instanceof CompletedExceptionally)) {
            object = null;
        }
        CompletedExceptionally completedExceptionally = (CompletedExceptionally)object;
        if (completedExceptionally != null) {
            CompletedExceptionally completedExceptionally2;
            CompletedExceptionally it = completedExceptionally2 = completedExceptionally;
            throw it.cause;
        }
        return (T)state;
    }

    public BlockingCoroutine(@NotNull CoroutineContext parentContext, @NotNull Thread blockedThread, @Nullable EventLoop eventLoop, boolean privateEventLoop) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(parentContext, "parentContext");
        Intrinsics.checkParameterIsNotNull(blockedThread, "blockedThread");
        super(parentContext, true);
        this.blockedThread = blockedThread;
        this.eventLoop = eventLoop;
        this.privateEventLoop = privateEventLoop;
        if (this.privateEventLoop && !(bl = this.eventLoop instanceof BlockingEventLoop)) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

