/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    private static DecimalFormat dfCommas = new DecimalFormat("##.#");

    @Override
    public String getID() {
        return "theoneprobe:entity.default";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IEntityDisplayOverride override : TheOneProbe.theOneProbeImp.getEntityOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, entity, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        }
        if (entity instanceof EntityLivingBase) {
            Collection effects;
            int age;
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            if (Tools.show(mode, config.getShowMobHealth())) {
                int health = (int)livingBase.func_110143_aJ();
                int maxHealth = (int)livingBase.func_110138_aP();
                int armor = livingBase.func_70658_aO();
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Health: " + (Object)((Object)TextStyleClass.INFOIMP) + health + " / " + maxHealth);
                }
                if (armor > 0) {
                    probeInfo.progress(armor, armor, probeInfo.defaultProgressStyle().armorBar(true).showText(false).width(80).height(10));
                }
            }
            if (Tools.show(mode, config.getShowMobGrowth()) && entity instanceof EntityAgeable && (age = ((EntityAgeable)entity).func_70874_b()) < 0) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Growing time: " + age * -1 / 20 + "s");
            }
            if (Tools.show(mode, config.getShowMobPotionEffects()) && !(effects = livingBase.func_70651_bq()).isEmpty()) {
                IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1));
                float durationFactor = 1.0f;
                for (PotionEffect effect : effects) {
                    String s1 = "{*" + effect.func_76453_d() + "*}";
                    Potion potion = effect.func_188419_a();
                    if (effect.func_76458_c() > 0) {
                        s1 = s1 + " " + "{*" + "potion.potency." + effect.func_76458_c() + "*}";
                    }
                    if (effect.func_76459_b() > 20) {
                        s1 = s1 + " (" + DefaultProbeInfoEntityProvider.getPotionDurationString(effect, durationFactor) + ")";
                    }
                    if (potion.func_76398_f()) {
                        vertical.text((Object)((Object)TextStyleClass.ERROR) + s1);
                        continue;
                    }
                    vertical.text((Object)((Object)TextStyleClass.OK) + s1);
                }
            }
        } else if (entity instanceof EntityItemFrame) {
            EntityItemFrame itemFrame = (EntityItemFrame)entity;
            ItemStack stack = itemFrame.func_82335_i();
            if (!stack.func_190926_b()) {
                probeInfo.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).item(stack, new ItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.INFO) + stack.func_82833_r());
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Rotation: " + (Object)((Object)TextStyleClass.INFO) + itemFrame.func_82333_j());
                }
            } else {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Empty");
            }
        }
        if (Tools.show(mode, config.getAnimalOwnerSetting())) {
            UUID ownerId = null;
            if (entity instanceof IEntityOwnable) {
                ownerId = ((IEntityOwnable)entity).func_184753_b();
            } else if (entity instanceof EntityHorse) {
                ownerId = ((EntityHorse)entity).func_184780_dh();
            }
            if (ownerId != null) {
                String username = UsernameCache.getLastKnownUsername((UUID)ownerId);
                if (username == null) {
                    probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "Unknown owner");
                } else {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Owned by: " + (Object)((Object)TextStyleClass.INFO) + username);
                }
            } else if (entity instanceof EntityTameable) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Tameable");
            }
        }
        if (Tools.show(mode, config.getHorseStatSetting()) && entity instanceof EntityHorse) {
            double jumpStrength = ((EntityHorse)entity).func_110215_cj();
            double jumpHeight = -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Jump height: " + (Object)((Object)TextStyleClass.INFO) + dfCommas.format(jumpHeight));
            IAttributeInstance iattributeinstance = ((EntityHorse)entity).func_110148_a(SharedMonsterAttributes.field_111263_d);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Speed: " + (Object)((Object)TextStyleClass.INFO) + dfCommas.format(iattributeinstance.func_111126_e()));
        }
        if (entity instanceof EntityWolf && Config.showCollarColor && ((EntityWolf)entity).func_70909_n()) {
            EnumDyeColor collarColor = ((EntityWolf)entity).func_175546_cu();
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Collar: " + (Object)((Object)TextStyleClass.INFO) + collarColor.func_176610_l());
        }
    }

    public static String getPotionDurationString(PotionEffect effect, float factor) {
        if (effect.func_76459_b() == Short.MAX_VALUE) {
            return "**:**";
        }
        int i = MathHelper.func_76141_d((float)((float)effect.func_76459_b() * factor));
        return DefaultProbeInfoEntityProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, Entity entity, IProbeConfig config) {
        String modid = Tools.getModName(entity);
        if (Tools.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text((Object)((Object)TextStyleClass.NAME) + entity.func_145748_c_().func_150254_d()).text((Object)((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text((Object)((Object)TextStyleClass.NAME) + entity.func_145748_c_().func_150254_d());
        }
    }
}

