/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages.compat.crt;

import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import java.util.StringJoiner;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ActionItemStage
implements IAction {
    private ItemStack[] restrictions;

    public ActionItemStage(Item item) {
        this.restrictions = StackUtils.getAllItems((Item)item);
        if (this.restrictions.length == 0) {
            this.restrictions = new ItemStack[]{new ItemStack(item)};
        }
    }

    public ActionItemStage(IIngredient restricted) {
        this.restrictions = CraftTweakerMC.getItemStacks((List)restricted.getItems());
    }

    protected ItemStack[] getRestrictedItems() {
        return this.restrictions;
    }

    private String describeStack(ItemStack stack) {
        return String.format("%s - %s:%d%s", stack.func_82833_r(), StackUtils.getStackIdentifier((ItemStack)stack), stack.func_77960_j(), stack.func_77942_o() ? stack.func_77978_p().toString() : "");
    }

    protected String describeRestrictedStacks() {
        if (this.restrictions.length == 1) {
            return this.describeStack(this.restrictions[0]);
        }
        StringJoiner joiner = new StringJoiner(Constants.NEW_LINE);
        for (ItemStack stack : this.getRestrictedItems()) {
            joiner.add(this.describeStack(stack));
        }
        return this.getRestrictedItems().length + " entries: " + Constants.NEW_LINE + joiner.toString();
    }

    protected void validate() {
        if (this.restrictions.length == 0) {
            throw new IllegalArgumentException("No items or blocks found for this entry!");
        }
        for (ItemStack stack : this.restrictions) {
            if (!stack.func_190926_b()) continue;
            throw new IllegalArgumentException("Entry contains an empty/air stack!");
        }
    }
}

