/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Map;
import net.darkhax.bookshelf.lib.ItemStackMap;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.util.GameUtils;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.event.StagesSyncedEvent;
import net.darkhax.itemstages.ConfigurationHandler;
import net.darkhax.itemstages.StageCompare;
import net.darkhax.itemstages.jei.PluginItemStages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="itemstages", name="Item Stages", version="2.0.36", dependencies="after:jei;required-after:bookshelf;required-after:gamestages@[2.0.89,);required-after:crafttweaker", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class ItemStages {
    public static final LoggingHelper LOG = new LoggingHelper("Item Stages");
    public static final ItemStackMap<String> ITEM_STAGES = new ItemStackMap(StageCompare.INSTANCE);
    public static final ItemStackMap<String> CUSTOM_NAMES = new ItemStackMap(StageCompare.INSTANCE);
    public static final ListMultimap<String, ItemStack> SORTED_STAGES = ArrayListMultimap.create();
    public static final SetMultimap<Item, Tuple<ItemStack, String>> SORTED_ITEM_STAGES = Multimaps.newSetMultimap((Map)Maps.newIdentityHashMap(), Sets::newIdentityHashSet);
    public static final ListMultimap<String, FluidStack> FLUID_STAGES = ArrayListMultimap.create();
    private static final String TRANSLATE_DESCRIPTION = "tooltip.itemstages.description";
    private static final String TRANSLATE_INFO = "tooltip.itemstages.info";
    private static final String TRANSLATE_STAGE = "tooltip.itemstages.stage";
    private static final String TRANSLATE_DROP = "message.itemstages.drop";

    public static String getStage(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (Tuple entry : SORTED_ITEM_STAGES.get((Object)stack.func_77973_b())) {
                if (!StageCompare.INSTANCE.isValid(stack, entry.func_76341_a())) continue;
                return (String)entry.func_76340_b();
            }
        }
        return null;
    }

    private static String getUnfamiliarName(ItemStack stack) {
        return CUSTOM_NAMES.containsKey((Object)stack) ? (String)CUSTOM_NAMES.get((Object)stack) : "Unfamiliar Item";
    }

    private static void sendDropMessage(EntityPlayer player, ItemStack stack) {
        player.func_146105_b((ITextComponent)new TextComponentTranslation(TRANSLATE_DROP, new Object[]{ItemStages.getUnfamiliarName(stack)}), false);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new ConfigurationHandler(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerDig(PlayerEvent.BreakSpeed event) {
        String stage;
        if (!(ConfigurationHandler.allowInteractRestricted || event.getEntityPlayer().field_70170_p.field_72995_K || event.getEntityPlayer().func_184812_l_() || (stage = ItemStages.getStage(event.getEntityPlayer().func_184614_ca())) == null || GameStageHelper.hasStage((EntityPlayer)event.getEntityPlayer(), (String)stage))) {
            event.setNewSpeed(-1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPlayerDig(PlayerEvent.BreakSpeed event) {
        String stage;
        if (!ConfigurationHandler.allowInteractRestricted && event.getEntityPlayer().field_70170_p.field_72995_K && !event.getEntityPlayer().func_184812_l_() && (stage = ItemStages.getStage(event.getEntityPlayer().func_184614_ca())) != null && !GameStageHelper.clientHasStage((EntityPlayer)event.getEntityPlayer(), (String)stage)) {
            event.setNewSpeed(-1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        String stage;
        if (event.isCancelable() && event.getSide() == Side.SERVER && !ConfigurationHandler.allowInteractRestricted && !event.getEntityPlayer().func_184812_l_() && (stage = ItemStages.getStage(event.getItemStack())) != null && !GameStageHelper.hasStage((EntityPlayer)event.getEntityPlayer(), (String)stage)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.func_184812_l_()) {
                return;
            }
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack stack;
                String stage;
                if (ConfigurationHandler.allowHoldingRestricted && slot.func_188453_a() == EntityEquipmentSlot.Type.HAND || ConfigurationHandler.allowEquipRestricted && slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR || (stage = ItemStages.getStage(stack = player.func_184582_a(slot))) == null || GameStageHelper.hasStage((EntityPlayer)player, (String)stage)) continue;
                player.func_184201_a(slot, ItemStack.field_190927_a);
                player.func_71019_a(stack, false);
                ItemStages.sendDropMessage(player, stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        String stage = ItemStages.getStage(event.getItemStack());
        if (stage != null && !GameStageHelper.clientHasStage((EntityPlayer)PlayerUtils.getClientPlayer(), (String)stage) && ConfigurationHandler.changeRestrictionTooltip) {
            event.getToolTip().clear();
            event.getToolTip().add(TextFormatting.WHITE + ItemStages.getUnfamiliarName(event.getItemStack()));
            event.getToolTip().add(" ");
            event.getToolTip().add(TextFormatting.RED + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)TRANSLATE_DESCRIPTION, (Object[])new Object[0]));
            event.getToolTip().add(TextFormatting.RED + I18n.func_135052_a((String)TRANSLATE_INFO, (Object[])new Object[]{stage}));
        } else if (stage != null && (event.getEntityPlayer() != null && event.getEntityPlayer().func_184812_l_() || event.getFlags() == ITooltipFlag.TooltipFlags.ADVANCED)) {
            event.getToolTip().add(TextFormatting.BLUE + I18n.func_135052_a((String)TRANSLATE_STAGE, (Object[])new Object[0]) + " " + TextFormatting.WHITE + stage);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientSync(StagesSyncedEvent event) {
        if (Loader.isModLoaded((String)"jei") && GameUtils.isClient()) {
            PluginItemStages.syncHiddenItems(event.getEntityPlayer());
        }
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        LOG.info("Sorting {} staged items.", new Object[]{ITEM_STAGES.size()});
        long time = System.currentTimeMillis();
        for (Map.Entry entry : ITEM_STAGES.entrySet()) {
            SORTED_STAGES.put(entry.getValue(), entry.getKey());
            SORTED_ITEM_STAGES.put((Object)((ItemStack)entry.getKey()).func_77973_b(), (Object)new Tuple(entry.getKey(), entry.getValue()));
        }
        LOG.info("Sorting complete. Found {} stages. Took {}ms", new Object[]{SORTED_STAGES.keySet().size(), System.currentTimeMillis() - time});
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onClientLoadComplete(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(listener -> {
            if (Loader.isModLoaded((String)"jei") && GameUtils.isClient()) {
                LOG.info("Resyncing JEI info.", new Object[0]);
                PluginItemStages.syncHiddenItems(PlayerUtils.getClientPlayer());
            }
        });
    }
}

