/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean allowHoldingRestricted;
    public static boolean allowEquipRestricted;
    public static boolean allowInteractRestricted;
    public static boolean hideRestrictionsInJEI;
    public static boolean changeRestrictionTooltip;

    public ConfigurationHandler(File file) {
        config = new Configuration(file);
        this.syncConfigData();
    }

    private void syncConfigData() {
        allowHoldingRestricted = config.getBoolean("allowHoldingRestricted", "general", false, "Should players be allowed to hold items that are restricted to them.");
        allowEquipRestricted = config.getBoolean("allowEquipRestricted", "general", false, "Should players be allowed to equip items that are restricted to them.");
        allowInteractRestricted = config.getBoolean("allowInteractRestricted", "general", false, "Should players be allowed to interact (left/right click) with items that are restricted to them.");
        hideRestrictionsInJEI = config.getBoolean("hideRestrictionsInJEI", "general", true, "Should restricted items be hidden in JEI?");
        changeRestrictionTooltip = config.getBoolean("changeRestrictionTooltip", "general", true, "Should restricted items have their tooltips changed?");
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        allowHoldingRestricted = false;
        allowEquipRestricted = false;
        allowInteractRestricted = false;
        hideRestrictionsInJEI = true;
        changeRestrictionTooltip = true;
    }
}

