/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigTeam;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.gui.FTBQuestsGuiHandler;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileQuestChest
extends TileBase
implements IItemHandler,
IConfigCallback {
    public String team = "";
    public boolean indestructible = false;
    private ITeamData cTeam;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (!this.team.isEmpty()) {
            nbt.func_74778_a("Team", this.team);
        }
        if (this.indestructible) {
            nbt.func_74757_a("Indestructible", true);
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.team = nbt.func_74779_i("Team");
        this.indestructible = nbt.func_74767_n("Indestructible");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.cTeam = null;
    }

    @Nullable
    public ITeamData getTeam() {
        if (this.team.isEmpty()) {
            return null;
        }
        if (this.cTeam == null) {
            this.cTeam = FTBQuests.PROXY.getQuestFile(this.field_145850_b).getData(this.team);
        }
        return this.cTeam;
    }

    public boolean isOwner(EntityPlayer player) {
        return this.team.isEmpty() || FTBLibAPI.isPlayerInTeam((UUID)player.func_110124_au(), (String)this.team);
    }

    public void openGui(EntityPlayerMP player) {
        if (!player.func_70093_af()) {
            if (this.isOwner((EntityPlayer)player)) {
                FTBQuestsGuiHandler.CHEST.open((EntityPlayer)player, this.field_174879_c);
            }
            return;
        }
        boolean editor = FTBQuests.canEdit(player);
        ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
        group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.chest.name", new Object[0]));
        ConfigGroup group = group0.getGroup("ftbquests.chest");
        group.add("team", (ConfigValue)new ConfigTeam(this.team){

            public void setString(String v) {
                TileQuestChest.this.team = v;
            }
        }, (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0])).setCanEdit(editor);
        if (editor) {
            group.add("indestructible", (ConfigValue)new ConfigBoolean(this.indestructible){

                public void setBoolean(boolean v) {
                    TileQuestChest.this.indestructible = v;
                }
            }, (ConfigValue)new ConfigBoolean(false)).setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.screen.indestructible", new Object[0]));
        }
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.insert(stack, simulate, null);
    }

    public ItemStack insert(ItemStack stack, boolean simulate, @Nullable EntityPlayer player) {
        QuestFile file = FTBQuests.PROXY.getQuestFile(this.field_145850_b);
        this.cTeam = this.getTeam();
        if (this.cTeam != null) {
            for (QuestTask task : file.allTasks) {
                if (!task.canInsertItem() || task.isComplete(this.cTeam) || !task.quest.canStartTasks(this.cTeam) || !(stack = this.cTeam.getQuestTaskData(task).insertItem(stack, false, simulate, player)).func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_70296_d();
    }

    public boolean canBeWrenched(EntityPlayer player) {
        return !this.indestructible;
    }
}

