/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigTeam;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileProgressDetector
extends TileBase
implements ITickable,
IConfigCallback {
    public String team = "";
    public String object = "*";
    public boolean level = false;
    public int redstoneOutput = 0;
    private ITeamData cTeam;
    private QuestObject cObject;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (!this.team.isEmpty()) {
            nbt.func_74778_a("Team", this.team);
        }
        this.cObject = this.getObject();
        if (this.cObject != null) {
            this.object = this.cObject.getID();
        }
        if (!this.object.isEmpty()) {
            nbt.func_74778_a("Object", this.object);
        }
        if (this.level) {
            nbt.func_74757_a("Level", true);
        }
        if (this.redstoneOutput > 0 && !type.item) {
            nbt.func_74774_a("RedstoneOutput", (byte)this.redstoneOutput);
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.team = nbt.func_74779_i("Team");
        this.object = nbt.func_74779_i("Object");
        this.level = nbt.func_74767_n("Level");
        if (!type.item) {
            this.redstoneOutput = nbt.func_74771_c("RedstoneOutput");
        }
        this.func_145836_u();
    }

    public void writeToItem(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeData(nbt, EnumSaveType.ITEM);
        if (!nbt.func_82582_d()) {
            stack.func_77982_d(nbt);
        }
    }

    public void readFromItem(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        this.readData(nbt == null ? new NBTTagCompound() : nbt, EnumSaveType.ITEM);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.cTeam = null;
        this.cObject = null;
    }

    @Nullable
    public ITeamData getTeam() {
        if (this.team.isEmpty()) {
            return null;
        }
        if (this.cTeam == null) {
            this.cTeam = FTBQuests.PROXY.getQuestFile(this.field_145850_b).getData(this.team);
        }
        return this.cTeam;
    }

    @Nullable
    public QuestObject getObject() {
        if (this.object.isEmpty()) {
            return null;
        }
        if (this.cObject == null || this.cObject.invalid) {
            this.cObject = FTBQuests.PROXY.getQuestFile(this.field_145850_b).get(this.object);
        }
        return this.cObject;
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_145836_u();
        this.func_70296_d();
        this.updateRedstoneOutput();
        BlockUtils.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)this.getBlockState());
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 7L == 0L) {
            this.updateRedstoneOutput();
        }
        this.checkIfDirty();
    }

    public void updateRedstoneOutput() {
        int rout = this.redstoneOutput;
        this.redstoneOutput = 0;
        this.cTeam = this.getTeam();
        this.cObject = this.getObject();
        if (this.cTeam != null && this.cObject != null) {
            int rel = this.cObject.getRelativeProgress(this.cTeam);
            if (rel >= 100) {
                this.redstoneOutput = 15;
            } else if (rel > 0 && this.level) {
                this.redstoneOutput = 1 + (int)((double)rel * 14.0 / 100.0);
            }
        }
        if (rout != this.redstoneOutput) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
        }
    }

    public void editConfig(EntityPlayerMP player) {
        if (!player.func_70093_af()) {
            return;
        }
        boolean editor = FTBQuests.canEdit(player);
        if (!editor && !this.team.equals(Universe.get().getPlayer((ICommandSender)player).team.func_176610_l())) {
            return;
        }
        this.cObject = this.getObject();
        if (this.cObject != null) {
            this.object = this.cObject.getID();
        }
        ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
        group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.progress_detector.name", new Object[0]));
        ConfigGroup group = group0.getGroup("ftbquests.progress_detector");
        group.add("team", (ConfigValue)new ConfigTeam(this.team){

            public void setString(String v) {
                TileProgressDetector.this.team = v;
            }
        }, (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0])).setCanEdit(editor);
        group.add("object", (ConfigValue)new ConfigQuestObject(this.object){

            public void setString(String v) {
                TileProgressDetector.this.object = v;
            }
        }.addType(QuestObjectType.FILE).addType(QuestObjectType.CHAPTER).addType(QuestObjectType.QUEST).addType(QuestObjectType.TASK).addType(QuestObjectType.VARIABLE), (ConfigValue)new ConfigQuestObject("*"));
        group.add("level", (ConfigValue)new ConfigBoolean(this.level){

            public void setBoolean(boolean v) {
                TileProgressDetector.this.level = v;
            }
        }, (ConfigValue)new ConfigBoolean(false));
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
    }
}

