/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.tasks;

import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public final class QuestTaskType
extends IForgeRegistryEntry.Impl<QuestTaskType> {
    private static IForgeRegistry<QuestTaskType> REGISTRY;
    private static Map<Class, QuestTaskType> TYPE_MAP;
    public final Class typeClass;
    public final Provider provider;
    private ITextComponent displayName;

    public static void createRegistry() {
        if (REGISTRY == null) {
            ResourceLocation registryName = new ResourceLocation("ftbquests", "tasks");
            REGISTRY = new RegistryBuilder().setType(QuestTaskType.class).setName(registryName).create();
            MinecraftForge.EVENT_BUS.post((Event)new RegistryEvent.Register(registryName, REGISTRY));
            TYPE_MAP = new HashMap<Class, QuestTaskType>();
            for (QuestTaskType type : REGISTRY) {
                TYPE_MAP.put(type.typeClass, type);
            }
        }
    }

    public static IForgeRegistry<QuestTaskType> getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public static QuestTask createTask(Quest quest, NBTTagCompound nbt) {
        QuestTaskType type;
        String id = nbt.func_74779_i("type");
        if (id.isEmpty()) {
            return null;
        }
        if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        if ((type = (QuestTaskType)REGISTRY.getValue(new ResourceLocation(id))) == null) {
            return null;
        }
        QuestTask task = type.provider.create(quest, nbt);
        if (task == null) {
            return null;
        }
        task.readID(nbt);
        task.title = nbt.func_74779_i("title");
        task.icon = ItemStackSerializer.read((NBTTagCompound)nbt.func_74775_l("icon"));
        task.completionCommand = nbt.func_74779_i("completion_command");
        return task;
    }

    @Nullable
    public static QuestTaskType getType(Class clazz) {
        return TYPE_MAP.get(clazz);
    }

    public static String getTypeForNBT(Class clazz) {
        QuestTaskType type = QuestTaskType.getType(clazz);
        return type == null ? "" : type.getTypeForNBT();
    }

    public QuestTaskType(Class<? extends QuestTask> c, Provider p) {
        this.typeClass = c;
        this.provider = p;
        this.displayName = null;
    }

    public String getTypeForNBT() {
        return this.getRegistryName().func_110624_b().equals("ftbquests") ? this.getRegistryName().func_110623_a() : ((Object)((Object)this)).toString();
    }

    public QuestTaskType setDisplayName(ITextComponent name) {
        this.displayName = name;
        return this;
    }

    public ITextComponent getDisplayName() {
        if (this.displayName != null) {
            return this.displayName.func_150259_f();
        }
        ResourceLocation id = this.getRegistryName();
        return new TextComponentTranslation("ftbquests.task." + id.func_110624_b() + '.' + id.func_110623_a(), new Object[0]);
    }

    public static interface Provider {
        @Nullable
        public QuestTask create(Quest var1, NBTTagCompound var2);
    }
}

