/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.tasks;

import com.feed_the_beast.ftbquests.gui.GuiTask;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public abstract class QuestTaskData<T extends QuestTask>
implements ICapabilityProvider,
IItemHandler {
    public final T task;
    public final ITeamData teamData;
    public boolean isComplete = false;

    public QuestTaskData(T q, ITeamData d) {
        this.task = q;
        this.teamData = d;
    }

    @Nullable
    public abstract NBTBase toNBT();

    public abstract void fromNBT(@Nullable NBTBase var1);

    public abstract long getProgress();

    public abstract void resetProgress();

    public abstract void completeInstantly();

    public int getRelativeProgress() {
        long max = ((QuestTask)this.task).getMaxProgress();
        if (max <= 0L) {
            return 0;
        }
        long progress = this.getProgress();
        if (progress <= 0L) {
            return 0;
        }
        if (progress >= max) {
            return 100;
        }
        return (int)((double)progress * 100.0 / (double)max);
    }

    public String getProgressString() {
        return Long.toString(this.getProgress());
    }

    public String toString() {
        return this.teamData + "@" + ((QuestTask)this.task).getID();
    }

    public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
        return stack;
    }

    public final int getSlots() {
        return 1;
    }

    public final ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public final ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (((QuestTask)this.task).canInsertItem() && ((QuestTask)this.task).getMaxProgress() > 0L && this.getProgress() < ((QuestTask)this.task).getMaxProgress() && !stack.func_190926_b()) {
            return this.insertItem(stack, false, simulate, null);
        }
        return stack;
    }

    public final ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public void addTabs(List<GuiTask.Tab> tabs) {
    }

    public final void sync() {
        this.teamData.syncTask(this);
    }
}

