/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.tasks;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.tasks.SimpleQuestTaskData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemTask
extends QuestTask
implements Predicate<ItemStack> {
    public final List<ItemStack> items = new ArrayList<ItemStack>();
    public long count;

    public ItemTask(Quest quest, NBTTagCompound nbt) {
        super(quest);
        NBTTagList list = nbt.func_150295_c("items", 10);
        if (list.func_82582_d()) {
            ItemStack stack = ItemStackSerializer.read((NBTTagCompound)nbt.func_74775_l("item"));
            if (!stack.func_190926_b()) {
                this.items.add(stack);
            }
        } else {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack stack = ItemStackSerializer.read((NBTTagCompound)list.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                this.items.add(stack);
            }
        }
        this.count = nbt.func_74763_f("count");
        if (this.count < 1L) {
            this.count = 1L;
        }
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        if (this.items.size() == 1) {
            nbt.func_74782_a("item", (NBTBase)ItemStackSerializer.write((ItemStack)this.items.get(0)));
        } else {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.items) {
                if (stack.func_190926_b()) continue;
                list.func_74742_a((NBTBase)ItemStackSerializer.write((ItemStack)stack));
            }
            nbt.func_74782_a("items", (NBTBase)list);
        }
        if (this.count > 1L) {
            nbt.func_74772_a("count", this.count);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (ItemStack stack : this.items) {
            Icon icon = ItemIcon.getItemIcon((ItemStack)stack);
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return GuiIcons.ACCEPT;
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        String name;
        if (this.items.size() == 1) {
            name = this.items.get(0).func_82833_r();
        } else {
            String[] s = new String[this.items.size()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = this.items.get(i).func_82833_r();
            }
            name = "[" + StringJoiner.with((String)", ").joinStrings(s) + "]";
        }
        if (this.count > 1L) {
            name = this.count + "x " + name;
        }
        return new TextComponentString(name);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_190916_E() != 1) {
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        for (ItemStack stack1 : this.items) {
            if (!ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)stack, (ItemStack)stack1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.add("items", (ConfigValue)new ConfigList<ConfigItemStack>(new ConfigItemStack(ItemStack.field_190927_a, true)){

            public void readFromList() {
                ItemTask.this.items.clear();
                for (ConfigItemStack value : this.list) {
                    ItemTask.this.items.add(value.getStack());
                }
            }

            public void writeToList() {
                this.list.clear();
                for (ItemStack stack : ItemTask.this.items) {
                    this.list.add(new ConfigItemStack(stack, true));
                }
            }
        }, (ConfigValue)new ConfigList((ConfigValue)new ConfigItemStack(ItemStack.field_190927_a, true)));
        group.add("count", (ConfigValue)new ConfigLong(1L, 1L, Long.MAX_VALUE){

            public long getLong() {
                return ItemTask.this.count;
            }

            public void setLong(long v) {
                ItemTask.this.count = v;
            }
        }, (ConfigValue)new ConfigLong(1L));
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list) {
        super.addMouseOverText(list);
        for (ItemStack stack : this.items) {
            list.add("---");
            List l = stack.func_82840_a((EntityPlayer)ClientUtils.MC.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            list.add(stack.func_77953_t().field_77937_e + (String)l.get(0));
            for (int i = 1; i < l.size(); ++i) {
                list.add(TextFormatting.GRAY + (String)l.get(i));
            }
        }
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<ItemTask> {
        private Data(ItemTask t, ITeamData data) {
            super(t, data);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
            long add;
            if (((ItemTask)this.task).test(stack) && (add = Math.min((long)stack.func_190916_E(), ((ItemTask)this.task).count - this.progress)) > 0L) {
                if (singleItem) {
                    add = 1L;
                }
                if (!simulate) {
                    this.progress += add;
                    this.sync();
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((int)((long)stack.func_190916_E() - add)));
            }
            return stack;
        }

        @Override
        public int getSlotLimit(int slot) {
            return (int)Math.min(64L, ((ItemTask)this.task).count - this.progress);
        }
    }
}

