/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.tasks;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigFluid;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.config.ConfigNBT;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.tasks.SimpleQuestTaskData;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidTask
extends QuestTask {
    private static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/tank.png");
    public Fluid fluid;
    public NBTTagCompound fluidNBT;
    public long amount;

    public FluidTask(Quest quest, NBTTagCompound nbt) {
        super(quest);
        this.fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("fluid"));
        if (this.fluid == null) {
            this.fluid = FluidRegistry.WATER;
        }
        this.fluidNBT = (NBTTagCompound)nbt.func_74781_a("nbt");
        long l = this.amount = nbt.func_74764_b("amount") ? nbt.func_74763_f("amount") : 1000L;
        if (this.amount < 1L) {
            this.amount = 1L;
        }
    }

    @Override
    public long getMaxProgress() {
        return this.amount;
    }

    @Override
    public String getMaxProgressString() {
        return FluidTask.getVolumeString(this.amount);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        nbt.func_74778_a("fluid", this.fluid.getName());
        if (this.amount != 1000L) {
            nbt.func_74772_a("amount", this.amount);
        }
        if (this.fluidNBT != null) {
            nbt.func_74782_a("nbt", (NBTBase)this.fluidNBT);
        }
    }

    @Override
    public Icon getAltIcon() {
        return Icon.getIcon((String)this.fluid.getStill(this.createFluidStack(1000)).toString()).combineWith(Icon.getIcon((String)TANK_TEXTURE.toString()));
    }

    public FluidStack createFluidStack(int amount) {
        return new FluidStack(this.fluid, amount, this.fluidNBT);
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= 1000L) {
            if (a % 1000L != 0L) {
                builder.append((double)a / 1000.0);
            } else {
                builder.append(a / 1000L);
            }
        } else {
            builder.append(a % 1000L);
        }
        builder.append(' ');
        if (a < 1000L) {
            builder.append('m');
        }
        builder.append('B');
        return builder.toString();
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentString(FluidTask.getVolumeString(this.amount)).func_150258_a(" of ").func_150258_a(this.createFluidStack(1000).getLocalizedName());
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.add("fluid", (ConfigValue)new ConfigFluid(FluidRegistry.WATER, FluidRegistry.WATER){

            public Fluid getFluid() {
                return FluidTask.this.fluid;
            }

            public void setFluid(Fluid v) {
                FluidTask.this.fluid = v;
            }
        }, (ConfigValue)new ConfigFluid(FluidRegistry.WATER, FluidRegistry.WATER));
        group.add("fluid_nbt", (ConfigValue)new ConfigNBT(null){

            @Nullable
            public NBTTagCompound getNBT() {
                return FluidTask.this.fluidNBT;
            }

            public void setNBT(@Nullable NBTTagCompound v) {
                FluidTask.this.fluidNBT = v;
            }
        }, (ConfigValue)new ConfigNBT(null));
        group.add("amount", (ConfigValue)new ConfigLong(1L, 1L, Long.MAX_VALUE){

            public long getLong() {
                return FluidTask.this.amount;
            }

            public void setLong(long v) {
                FluidTask.this.amount = v;
            }
        }, (ConfigValue)new ConfigLong(1000L));
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGUI(@Nullable QuestTaskData data, int x, int y, int w, int h) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        double d = r = data == null ? 0.0 : (double)data.getRelativeProgress() / 100.0;
        if (r > 0.0) {
            double h1 = r * 30.0 / 32.0 * (double)h;
            double y1 = (double)y + (0.03125 + (1.0 - r) * 30.0 / 32.0) * (double)h;
            FluidStack stack = this.createFluidStack(1000);
            TextureAtlasSprite sprite = ClientUtils.MC.func_147117_R().func_110572_b(stack.getFluid().getStill(stack).toString());
            int color = stack.getFluid().getColor(stack);
            int alpha = color >> 24 & 0xFF;
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            double u0 = sprite.func_94209_e();
            double v0 = (double)sprite.func_94206_g() + (double)(sprite.func_94210_h() - sprite.func_94206_g()) * (1.0 - r);
            double u1 = sprite.func_94212_f();
            double v1 = sprite.func_94210_h();
            ClientUtils.MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            ClientUtils.MC.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)x, y1 + h1, 0.0).func_187315_a(u0, v1).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1 + h1, 0.0).func_187315_a(u1, v1).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1, 0.0).func_187315_a(u1, v0).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b((double)x, y1, 0.0).func_187315_a(u0, v0).func_181669_b(red, green, blue, alpha).func_181675_d();
            tessellator.func_78381_a();
            ClientUtils.MC.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
        ClientUtils.MC.func_110434_K().func_110577_a(TANK_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreen(@Nullable QuestTaskData data) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        ClientUtils.MC.func_110434_K().func_110577_a(TANK_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double x = -0.5;
        double y = -0.5;
        double w = 1.0;
        double h = 1.0;
        double z = 0.0;
        buffer.func_181662_b(x, y + h, z).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y + h, z).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y, z).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.getRelativeProgress() / 100.0;
        if (r > 0.0) {
            x += 0.0078125;
            w -= 0.015625;
            h = r * 30.0 / 32.0;
            y = 0.03125 + (1.0 - r) * 30.0 / 32.0 - 0.5;
            y -= 0.0078125;
            h += 0.015625;
            z = 0.003;
            FluidStack stack = this.createFluidStack(1000);
            TextureAtlasSprite sprite = ClientUtils.MC.func_147117_R().func_110572_b(stack.getFluid().getStill(stack).toString());
            int color = stack.getFluid().getColor(stack);
            int alpha = color >> 24 & 0xFF;
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            double u0 = sprite.func_94209_e();
            double v0 = (double)sprite.func_94206_g() + (double)(sprite.func_94210_h() - sprite.func_94206_g()) * (1.0 - r);
            double u1 = sprite.func_94212_f();
            double v1 = sprite.func_94210_h();
            ClientUtils.MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            ClientUtils.MC.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(x, y + h, z).func_187315_a(u0, v1).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + w, y + h, z).func_187315_a(u1, v1).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + w, y, z).func_187315_a(u1, v0).func_181669_b(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(u0, v0).func_181669_b(red, green, blue, alpha).func_181675_d();
            tessellator.func_78381_a();
            ClientUtils.MC.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<FluidTask>
    implements IFluidHandler {
        private final IFluidTankProperties[] properties = new IFluidTankProperties[1];

        private Data(FluidTask t, ITeamData data) {
            super(t, data);
            this.properties[0] = new FluidTankProperties(((FluidTask)this.task).createFluidStack(0), 0, true, false);
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
        }

        @Override
        public String getProgressString() {
            return FluidTask.getVolumeString(this.progress);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.properties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            long add;
            FluidStack fluidStack = ((FluidTask)this.task).createFluidStack(1000);
            if (this.progress < ((FluidTask)this.task).amount && fluidStack.isFluidEqual(resource) && (add = Math.min(100000000000L, Math.min((long)resource.amount, ((FluidTask)this.task).amount - this.progress))) > 0L) {
                if (doFill) {
                    this.progress += add;
                    this.sync();
                }
                return (int)add;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
            if (player == null) {
                return stack;
            }
            IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (inv == null) {
                return stack;
            }
            ItemStack stack1 = stack.func_77946_l();
            FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack1, (IFluidHandler)this, (IItemHandler)inv, (int)Integer.MAX_VALUE, (EntityPlayer)player, (!simulate ? 1 : 0) != 0);
            if (!result.isSuccess()) {
                result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack1, (IFluidHandler)this, (IItemHandler)inv, (int)Integer.MAX_VALUE, (EntityPlayer)player, (!simulate ? 1 : 0) != 0);
            }
            return result.isSuccess() ? result.getResult() : stack;
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

