/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class QuestObject {
    public static final Pattern ID_PATTERN = Pattern.compile("^[a-z0-9_]{1,32}$");
    private static final Pattern CUSTOM_ID_1 = Pattern.compile("[^a-z0-9_]");
    private static final Pattern CUSTOM_ID_2 = Pattern.compile("_+");
    public String id = "";
    public boolean invalid = false;
    public String title = "";
    public ItemStack icon = ItemStack.field_190927_a;
    private Icon cachedIcon = null;
    public String completionCommand = "";

    public static String customId(String string) {
        return CUSTOM_ID_2.matcher(CUSTOM_ID_1.matcher(string.toLowerCase()).replaceAll("_")).replaceAll("_");
    }

    public abstract QuestFile getQuestFile();

    public abstract QuestObjectType getObjectType();

    public abstract String getID();

    public abstract void writeData(NBTTagCompound var1);

    public abstract Icon getAltIcon();

    public abstract long getProgress(ITeamData var1);

    public abstract long getMaxProgress();

    public abstract void resetProgress(ITeamData var1);

    public abstract void completeInstantly(ITeamData var1);

    public abstract int getRelativeProgress(ITeamData var1);

    public static int fixRelativeProgress(int progress, int max) {
        if (max <= 0) {
            return 100;
        }
        if (progress <= 0) {
            return 0;
        }
        if (progress >= max * 100) {
            return 100;
        }
        return (int)((double)progress / (double)max);
    }

    public abstract boolean isComplete(ITeamData var1);

    public void onCompleted(ITeamData data) {
        new ObjectCompletedEvent(data, this).post();
        if (!this.completionCommand.isEmpty()) {
            Universe.get().server.field_71321_q.func_71556_a((ICommandSender)Universe.get().server, this.completionCommand.replace("@team", data.getTeamID()).replace("@id", this.getID()).replace("@idn", this.getID().replace(':', '_')));
        }
    }

    public final Icon getIcon() {
        if (this.cachedIcon == null) {
            this.cachedIcon = !this.icon.func_190926_b() ? ItemIcon.getItemIcon((ItemStack)this.icon) : this.getAltIcon();
        }
        return this.cachedIcon;
    }

    public abstract ITextComponent getAltDisplayName();

    public final ITextComponent getDisplayName() {
        if (!this.title.isEmpty()) {
            return new TextComponentString(this.title.equals("-") ? "" : this.title);
        }
        return this.getAltDisplayName();
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.getID());
        this.invalid = true;
    }

    public void deleteChildren() {
    }

    public void onCreated() {
    }

    public final String toString() {
        return this.getID();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return o == this;
    }

    public void getConfig(ConfigGroup config) {
    }

    public void getExtraConfig(ConfigGroup config) {
        config.add("title", (ConfigValue)new ConfigString(this.title){

            public String getString() {
                return QuestObject.this.title;
            }

            public void setString(String v) {
                QuestObject.this.title = v;
            }
        }, (ConfigValue)new ConfigString("")).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.title", new Object[0])).setOrder((byte)-127);
        config.add("icon", (ConfigValue)new ConfigItemStack(this.icon, true){

            public ItemStack getStack() {
                return QuestObject.this.icon;
            }

            public void setStack(ItemStack v) {
                QuestObject.this.icon = v;
            }
        }, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.icon", new Object[0])).setOrder((byte)-126);
        config.add("completion_command", (ConfigValue)new ConfigString(this.completionCommand){

            public String getString() {
                return QuestObject.this.completionCommand;
            }

            public void setString(String v) {
                QuestObject.this.completionCommand = v;
            }
        }, (ConfigValue)new ConfigString("")).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.completion_command", new Object[0])).setOrder((byte)-106);
    }

    public void readID(NBTTagCompound nbt) {
        this.id = nbt.func_74779_i("id").trim();
        if (this.id.isEmpty() || this.getQuestFile().get(this.getID()) != null) {
            this.id = StringUtils.fromUUID((UUID)UUID.randomUUID()).substring(0, 8);
        }
    }

    public void clearCachedData() {
        this.cachedIcon = null;
    }
}

