/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.quest.EnumQuestVisibilityType;
import com.feed_the_beast.ftbquests.quest.EnumVisibility;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class Quest
extends QuestObject {
    public static final int POS_LIMIT = 25;
    public final QuestChapter chapter;
    public String description;
    public EnumQuestVisibilityType visibilityType;
    public byte x;
    public byte y;
    public final List<String> text;
    public final List<QuestTask> tasks;
    public final List<QuestReward> rewards;
    public int timesCompleted;
    private String cachedID = "";
    private Collection<QuestObject> cachedDependencies;

    public Quest(QuestChapter c, NBTTagCompound nbt) {
        QuestReward reward;
        ItemStack stack;
        NBTTagCompound nbt1;
        int i;
        this.chapter = c;
        this.readID(nbt);
        this.title = nbt.func_74779_i("title");
        this.description = nbt.func_74779_i("description");
        this.icon = ItemStackSerializer.read((NBTTagCompound)nbt.func_74775_l("icon"));
        this.completionCommand = nbt.func_74779_i("completion_command");
        this.visibilityType = (EnumQuestVisibilityType)((Object)EnumQuestVisibilityType.NAME_MAP.get(nbt.func_74779_i("visibility")));
        this.x = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("x"), (int)-25, (int)25);
        this.y = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("y"), (int)-25, (int)25);
        this.text = new ArrayList<String>();
        NBTTagList list = nbt.func_150295_c("text", 8);
        for (int k = 0; k < list.func_74745_c(); ++k) {
            this.text.add(list.func_150307_f(k));
        }
        this.tasks = new ArrayList<QuestTask>();
        this.rewards = new ArrayList<QuestReward>();
        list = nbt.func_150295_c("tasks", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            QuestTask task = QuestTaskType.createTask(this, list.func_150305_b(i));
            if (task == null) continue;
            this.tasks.add(task);
        }
        list = nbt.func_150295_c("rewards", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            int uid;
            ItemStack stack2 = ItemStack.field_190927_a;
            NBTTagCompound nbt12 = list.func_150305_b(i);
            if (nbt12.func_74764_b("type")) {
                switch (nbt12.func_74779_i("type")) {
                    case "item": {
                        stack2 = ItemStackSerializer.read((NBTTagCompound)nbt12.func_74775_l("item"));
                        break;
                    }
                    case "xp": {
                        stack2 = new ItemStack(FTBQuestsItems.XP_VIAL);
                        stack2.func_77983_a("xp", (NBTBase)new NBTTagInt(nbt12.func_74762_e("xp")));
                        break;
                    }
                    case "xp_levels": {
                        stack2 = new ItemStack(FTBQuestsItems.XP_VIAL);
                        stack2.func_77983_a("xp_levels", (NBTBase)new NBTTagInt(nbt12.func_74762_e("xp_levels")));
                        break;
                    }
                    case "command": {
                        stack2 = new ItemStack(FTBQuestsItems.SCRIPT);
                        stack2.func_77983_a("command", (NBTBase)new NBTTagString(nbt12.func_74779_i("command")));
                    }
                }
            } else {
                stack2 = ItemStackSerializer.read((NBTTagCompound)nbt12);
            }
            if (stack2.func_190926_b()) continue;
            if (nbt12.func_74764_b("title")) {
                stack2.func_151001_c(nbt12.func_74779_i("title"));
            }
            if ((uid = nbt12.func_74762_e("uid")) == 0) {
                uid = System.identityHashCode(stack2);
            }
            QuestReward reward2 = new QuestReward(this, uid);
            reward2.stack = stack2;
            reward2.team = nbt12.func_74767_n("team_reward");
            this.rewards.add(reward2);
        }
        list = nbt.func_150295_c("player_rewards", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt1 = list.func_150305_b(i);
            stack = ItemStackSerializer.read((NBTTagCompound)nbt1);
            if (stack.func_190926_b()) continue;
            reward = new QuestReward(this, System.identityHashCode(stack));
            reward.stack = stack;
            reward.team = false;
            this.rewards.add(reward);
        }
        list = nbt.func_150295_c("team_rewards", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt1 = list.func_150305_b(i);
            stack = ItemStackSerializer.read((NBTTagCompound)nbt1);
            if (stack.func_190926_b()) continue;
            reward = new QuestReward(this, System.identityHashCode(stack));
            reward.stack = stack;
            reward.team = true;
            this.rewards.add(reward);
        }
        this.timesCompleted = nbt.func_74762_e("times_completed");
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public String getID() {
        if (this.cachedID.isEmpty()) {
            this.cachedID = this.chapter.id + ':' + this.id;
        }
        return this.cachedID;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        NBTTagList array;
        nbt.func_74778_a("id", this.id);
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_74782_a("icon", (NBTBase)ItemStackSerializer.write((ItemStack)this.icon));
        }
        if (!this.completionCommand.isEmpty()) {
            nbt.func_74778_a("completion_command", this.completionCommand);
        }
        if (this.visibilityType != EnumQuestVisibilityType.NORMAL) {
            nbt.func_74778_a("type", this.visibilityType.func_176610_l());
        }
        nbt.func_74774_a("x", this.x);
        nbt.func_74774_a("y", this.y);
        if (!this.description.isEmpty()) {
            nbt.func_74778_a("description", this.description);
        }
        if (!this.text.isEmpty()) {
            array = new NBTTagList();
            for (String value : this.text) {
                array.func_74742_a((NBTBase)new NBTTagString(value));
            }
            nbt.func_74782_a("text", (NBTBase)array);
        }
        if (!this.tasks.isEmpty()) {
            array = new NBTTagList();
            for (QuestTask task : this.tasks) {
                QuestTaskType type = QuestTaskType.getType(task.getClass());
                if (type == null) continue;
                NBTTagCompound taskNBT = new NBTTagCompound();
                task.writeData(taskNBT);
                taskNBT.func_74778_a("id", task.id);
                taskNBT.func_74778_a("type", type.getTypeForNBT());
                if (!task.title.isEmpty()) {
                    taskNBT.func_74778_a("title", task.title);
                }
                if (!task.icon.func_190926_b()) {
                    taskNBT.func_74782_a("icon", (NBTBase)ItemStackSerializer.write((ItemStack)task.icon));
                }
                if (!task.completionCommand.isEmpty()) {
                    taskNBT.func_74778_a("completion_command", task.completionCommand);
                }
                array.func_74742_a((NBTBase)taskNBT);
            }
            nbt.func_74782_a("tasks", (NBTBase)array);
        }
        if (!this.rewards.isEmpty()) {
            array = new NBTTagList();
            for (QuestReward reward : this.rewards) {
                if (reward.stack.func_190926_b()) continue;
                NBTTagCompound nbt1 = ItemStackSerializer.write((ItemStack)reward.stack);
                nbt1.func_74768_a("uid", reward.uid);
                if (reward.team) {
                    nbt1.func_74757_a("team_reward", true);
                }
                array.func_74742_a((NBTBase)nbt1);
            }
            nbt.func_74782_a("rewards", (NBTBase)array);
        }
        if (this.timesCompleted > 0) {
            nbt.func_74768_a("times_completed", this.timesCompleted);
        }
    }

    @Override
    public long getProgress(ITeamData data) {
        long progress = 0L;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            progress += task.getProgress(data);
        }
        return progress;
    }

    @Override
    public long getMaxProgress() {
        long maxProgress = 0L;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            maxProgress += task.getMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        int progress = 0;
        int s = 0;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            progress += task.getRelativeProgress(data);
            ++s;
        }
        return Quest.fixRelativeProgress(progress, s);
    }

    @Override
    public boolean isComplete(ITeamData data) {
        for (QuestTask task : this.tasks) {
            if (task.invalid || task.isComplete(data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onCompleted(ITeamData data) {
        ++this.timesCompleted;
        super.onCompleted(data);
        if (this.chapter.isComplete(data)) {
            this.chapter.onCompleted(data);
        }
    }

    @Override
    public void resetProgress(ITeamData data) {
        for (QuestTask task : this.tasks) {
            task.resetProgress(data);
        }
        data.unclaimRewards(this.rewards);
    }

    @Override
    public void completeInstantly(ITeamData data) {
        for (QuestTask task : this.tasks) {
            task.completeInstantly(data);
        }
    }

    public boolean canStartTasks(ITeamData data) {
        return true;
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (QuestTask task : this.tasks) {
            if (task.getDependency() != null) continue;
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        for (QuestTask task : this.tasks) {
            if (task.getDependency() != null) continue;
            return task.getDisplayName();
        }
        return new TextComponentTranslation("ftbquests.unnamed", new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (QuestTask task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        this.tasks.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.add("x", (ConfigValue)new ConfigInt(this.x, -25, 25){

            public int getInt() {
                return Quest.this.x;
            }

            public void setInt(int v) {
                Quest.this.x = (byte)v;
            }
        }, (ConfigValue)new ConfigInt(0));
        group.add("y", (ConfigValue)new ConfigInt(this.y, -25, 25){

            public int getInt() {
                return Quest.this.y;
            }

            public void setInt(int v) {
                Quest.this.y = (byte)v;
            }
        }, (ConfigValue)new ConfigInt(0));
        group.add("visibility", (ConfigValue)new ConfigEnum<EnumQuestVisibilityType>(EnumQuestVisibilityType.NAME_MAP){

            public EnumQuestVisibilityType getValue() {
                return Quest.this.visibilityType;
            }

            public void setValue(EnumQuestVisibilityType v) {
                Quest.this.visibilityType = v;
            }
        }, (ConfigValue)new ConfigEnum(EnumQuestVisibilityType.NAME_MAP));
        group.add("description", (ConfigValue)new ConfigString(this.description){

            public String getString() {
                return Quest.this.description;
            }

            public void setString(String v) {
                Quest.this.description = v;
            }
        }, (ConfigValue)new ConfigString(""));
        group.add("text", (ConfigValue)new ConfigList<ConfigString>(new ConfigString("")){

            public void readFromList() {
                Quest.this.text.clear();
                for (ConfigString value : this.list) {
                    Quest.this.text.add(value.getString());
                }
            }

            public void writeToList() {
                this.list.clear();
                for (String value : Quest.this.text) {
                    this.list.add(new ConfigString(value));
                }
            }
        }, (ConfigValue)new ConfigList((ConfigValue)new ConfigString("")));
    }

    public EnumVisibility getVisibility(@Nullable ITeamData data) {
        EnumVisibility v = EnumVisibility.VISIBLE;
        return v;
    }

    public QuestTask getTask(int index) {
        if (this.tasks.isEmpty()) {
            throw new IllegalStateException("Quest has no tasks!");
        }
        if (index <= 0) {
            return this.tasks.get(0);
        }
        if (index >= this.tasks.size()) {
            return this.tasks.get(this.tasks.size() - 1);
        }
        return this.tasks.get(index);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedID = "";
        this.cachedDependencies = null;
        for (QuestTask task : this.tasks) {
            task.clearCachedData();
        }
    }

    public int hasDependency(QuestObject object) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (this.tasks.get(i).getDependency() != object) continue;
            return i;
        }
        return -1;
    }
}

