/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net.edit;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.FTBQuestsEditNetHandler;
import com.feed_the_beast.ftbquests.net.edit.MessageAddRewardResponse;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MessageAddReward
extends MessageToServer {
    private String quest;
    private boolean team;
    private ItemStack stack;

    public MessageAddReward() {
    }

    public MessageAddReward(String q, boolean t, ItemStack is) {
        this.quest = q;
        this.team = t;
        this.stack = is;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsEditNetHandler.EDIT;
    }

    public void writeData(DataOut data) {
        data.writeString(this.quest);
        data.writeBoolean(this.team);
        data.writeNBT(this.stack.func_190926_b() ? null : this.stack.serializeNBT());
    }

    public void readData(DataIn data) {
        this.quest = data.readString();
        this.team = data.readBoolean();
        NBTTagCompound nbt = data.readNBT();
        this.stack = nbt == null ? ItemStack.field_190927_a : new ItemStack(nbt);
    }

    public void onMessage(EntityPlayerMP player) {
        Quest q;
        if (!this.stack.func_190926_b() && !this.quest.isEmpty() && FTBQuests.canEdit(player) && (q = ServerQuestFile.INSTANCE.getQuest(this.quest)) != null) {
            QuestReward r = new QuestReward(q, System.identityHashCode(this.stack));
            r.team = this.team;
            r.stack = this.stack;
            q.rewards.add(r);
            ServerQuestFile.INSTANCE.allRewards.put(r.uid, (Object)r);
            ServerQuestFile.INSTANCE.save();
            new MessageAddRewardResponse(this.quest, r.uid, this.team, this.stack).sendToAll();
        }
    }
}

