/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.ContainerTask;
import com.feed_the_beast.ftbquests.gui.GuiTask;
import com.feed_the_beast.ftbquests.net.FTBQuestsNetHandler;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.tile.TileScreenBase;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageOpenTaskResponse
extends MessageToClient {
    private String task;
    private int window;
    private boolean hasPos;
    private BlockPos pos;

    public MessageOpenTaskResponse() {
    }

    public MessageOpenTaskResponse(String t, int w, boolean h, @Nullable BlockPos p) {
        this.task = t;
        this.window = w;
        this.hasPos = h;
        this.pos = p;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        data.writeString(this.task);
        data.writeInt(this.window);
        data.writeBoolean(this.hasPos);
        if (this.hasPos) {
            data.writePos((Vec3i)this.pos);
        }
    }

    public void readData(DataIn data) {
        this.task = data.readString();
        this.window = data.readInt();
        this.hasPos = data.readBoolean();
        if (this.hasPos) {
            this.pos = data.readPos();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        if (!ClientQuestFile.existsWithTeam()) {
            return;
        }
        QuestTask qtask = ClientQuestFile.INSTANCE.getTask(this.task);
        if (qtask != null && qtask.quest.canStartTasks(ClientQuestFile.INSTANCE.self)) {
            TileEntity tileEntity;
            ContainerTask container = new ContainerTask((EntityPlayer)ClientUtils.MC.field_71439_g, ClientQuestFile.INSTANCE.self.getQuestTaskData(qtask));
            container.field_75152_c = this.window;
            if (this.hasPos && (tileEntity = ClientUtils.MC.field_71441_e.func_175625_s(this.pos)) instanceof TileScreenBase) {
                container.screen = ((TileScreenBase)tileEntity).getScreen();
            }
            new GuiTask(container).openGui();
        }
    }
}

